/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;

public class PaginatedQueryResult
extends PaginatedNodeIterator {
    protected QueryCriteria queryCriteria;
    protected QueryResult queryResult;
    private NodeIterator iterator;

    public NodeIterator getIterator() {
        return this.iterator;
    }

    public void setIterator(NodeIterator iterator) {
        this.iterator = iterator;
    }

    public PaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public PaginatedQueryResult(QueryResult queryResult, int pageSize) throws Exception {
        super(pageSize);
        NodeIterator nodeIterator = queryResult.getNodes();
        this.setIterator(nodeIterator);
        Node node = null;
        this.nodes = new ArrayList();
        while (nodeIterator.hasNext()) {
            node = nodeIterator.nextNode();
            this.nodes.add(node);
        }
        this.setAvailablePage(this.nodes.size());
        this.queryResult = queryResult;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null && !this.currentListPage_.isEmpty()) {
            return;
        }
        this.checkAndSetPosition(page);
        this.currentListPage_ = new CopyOnWriteArrayList();
        int count = 0;
        RowIterator iterator = this.queryResult.getRows();
        NodeIterator nodeIterator = this.getIterator();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            long position = nodeIterator.getPosition();
            long rowPosition = iterator.getPosition();
            long skipNum = position - rowPosition;
            iterator.skip(skipNum - 1L);
            Row row = iterator.nextRow();
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.currentListPage_.add(resultNode);
            if (++count != this.getPageSize()) continue;
            break;
        }
        this.currentPage_ = page;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        PublicationService publicationService;
        String lifecycleName;
        Node displayNode = null;
        if (node.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if ((lifecycleName = (publicationService = (PublicationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationService.class)).getNodeLifecycleName(node)) == null) {
            return node;
        }
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecycleName);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("filter-mode", this.queryCriteria.isLiveMode() ? "Live" : "Edit");
        displayNode = publicationPlugin.getNodeView(node, context);
        return displayNode;
    }
}

