/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.value.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValue
extends JsonValue {
    private final Map<String, JsonValue> children = new HashMap<String, JsonValue>();

    @Override
    public void addElement(String key, JsonValue child) {
        this.children.put(key, child);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Iterator<String> getKeys() {
        return this.children.keySet().iterator();
    }

    @Override
    public JsonValue getElement(String key) {
        return this.children.get(key);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int i = 0;
        for (String key : this.children.keySet()) {
            if (i > 0) {
                sb.append(',');
            }
            ++i;
            sb.append(JsonUtils.getJsonString(key));
            sb.append(':');
            sb.append(this.children.get(key).toString());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeTo(JsonWriter writer) throws JsonException {
        writer.writeStartObject();
        for (String key : this.children.keySet()) {
            writer.writeKey(key);
            JsonValue v = this.children.get(key);
            v.writeTo(writer);
        }
        writer.writeEndObject();
    }
}

