/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.categories.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.categories.impl.TaxonomyConfig;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TaxonomyPlugin
extends BaseComponentPlugin {
    private RepositoryService repositoryService_;
    private String baseTaxonomiesPath_;
    private InitParams params_;
    private boolean autoCreateInNewRepository_ = true;
    private DMSConfiguration dmsConfiguration_;

    public TaxonomyPlugin(InitParams params, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        this.repositoryService_ = repositoryService;
        this.baseTaxonomiesPath_ = nodeHierarchyCreator.getJcrPath("exoTaxonomiesPath");
        this.params_ = params;
        ValueParam valueParam = this.params_.getValueParam("autoCreateInNewRepository");
        if (valueParam != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(valueParam.getValue());
        }
        this.dmsConfiguration_ = dmsConfiguration;
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            for (RepositoryEntry repositoryEntry : this.repositoryService_.getConfig().getRepositoryConfigurations()) {
                this.importPredefineTaxonomies(repositoryEntry.getName());
            }
            return;
        }
        ValueParam param = this.params_.getValueParam("repository");
        String repository = null;
        repository = param == null ? this.repositoryService_.getDefaultRepository().getConfiguration().getName() : param.getValue();
        this.importPredefineTaxonomies(repository);
    }

    public void init(String repository) throws Exception {
        if (!this.autoCreateInNewRepository_) {
            return;
        }
        this.importPredefineTaxonomies(repository);
    }

    private void importPredefineTaxonomies(String repository) throws Exception {
        DMSRepositoryConfiguration dmsRepoConfig;
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        Session session = manageableRepository.getSystemSession((dmsRepoConfig = this.dmsConfiguration_.getConfig(repository)).getSystemWorkspace());
        Node taxonomyHomeNode = (Node)session.getItem(this.baseTaxonomiesPath_);
        if (taxonomyHomeNode.hasProperty("exo:isImportedChildren")) {
            session.logout();
            return;
        }
        taxonomyHomeNode.setProperty("exo:isImportedChildren", true);
        Iterator it = this.params_.getObjectParamIterator();
        while (it.hasNext()) {
            TaxonomyConfig config = (TaxonomyConfig)((ObjectParameter)it.next()).getObject();
            for (TaxonomyConfig.Taxonomy taxonomy : config.getTaxonomies()) {
                Node taxonomyNode = Utils.makePath(taxonomyHomeNode, taxonomy.getPath(), "exo:taxonomy", this.getPermissions(taxonomy.getPermissions()));
                if (!taxonomyNode.canAddMixin("mix:referenceable")) continue;
                taxonomyNode.addMixin("mix:referenceable");
            }
        }
        taxonomyHomeNode.save();
        session.save();
        session.logout();
    }

    public Map getPermissions(List<TaxonomyConfig.Permission> permissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (TaxonomyConfig.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }
}

