/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.timeline.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.timeline.TimelineService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineServiceImpl
implements TimelineService {
    private static final Log LOG = ExoLogger.getLogger((String)"cms.timeline.TimelineServiceImpl");
    private static final String EXO_DATETIME = "exo:datetime";
    private static final String EXO_MODIFIED_DATE = "exo:dateModified";
    private static final String EXO_OWNER = "exo:owner";
    private static final String SELECT_QUERY = "SELECT * FROM exo:datetime WHERE ";
    private static final String TIME_FORMAT_TAIL = "T00:00:00.000+07:00";
    private static final SimpleDateFormat formatDateTime = new SimpleDateFormat();
    private RepositoryService repositoryService_;
    private TemplateService templateService_;
    private int itemPerTimeline = 5;

    public TimelineServiceImpl(RepositoryService repoService, TemplateService templateService, InitParams initParams) throws Exception {
        this.repositoryService_ = repoService;
        this.templateService_ = templateService;
        this.itemPerTimeline = Integer.parseInt(initParams.getValueParam("itemPerTimeline").getValue());
    }

    @Override
    public List<Node> getDocumentsOfEarlierThisYear(String nodePath, String repository, String workspace, SessionProvider sessionProvider, String userName, boolean byUser) throws Exception {
        ArrayList<Node> documentsOfYear = new ArrayList<Node>();
        Session session = this.getSession(sessionProvider, repository, workspace);
        GregorianCalendar currentTime = new GregorianCalendar();
        String strBeginningOfThisMonthTime = this.getStrBeginningOfThisMonthTime(currentTime);
        String strBeginningOfThisYearTime = this.getStrBeginningOfThisYearTime(currentTime);
        StringBuilder sb = new StringBuilder();
        String pathPattern = this.buildPathPattern(nodePath);
        sb.append(SELECT_QUERY);
        if (pathPattern.length() > 0) {
            sb.append(pathPattern).append(" AND ");
        }
        sb.append("(" + this.buildDocumentTypePattern(repository) + ")").append(" AND ").append(" (exo:dateModified >= TIMESTAMP '" + strBeginningOfThisYearTime + "')").append(" AND ").append(" (exo:dateModified < TIMESTAMP '" + strBeginningOfThisMonthTime + "')");
        if (byUser) {
            sb.append(" AND ").append(" (exo:owner = '" + userName + "')");
        }
        sb.append(" ORDER BY ").append(EXO_MODIFIED_DATE);
        QueryResult result = this.executeQuery(session, sb.toString(), "sql");
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            documentsOfYear.add(nodeIter.nextNode());
        }
        return documentsOfYear;
    }

    @Override
    public List<Node> getDocumentsOfEarlierThisMonth(String nodePath, String repository, String workspace, SessionProvider sessionProvider, String userName, boolean byUser) throws Exception {
        ArrayList<Node> documentsOfMonth = new ArrayList<Node>();
        Session session = this.getSession(sessionProvider, repository, workspace);
        GregorianCalendar currentTime = new GregorianCalendar();
        String strBeginningOfThisWeekTime = this.getStrBeginningOfThisWeekTime(currentTime);
        String strBeginningOfThisMonthTime = this.getStrBeginningOfThisMonthTime(currentTime);
        StringBuilder sb = new StringBuilder();
        String pathPattern = this.buildPathPattern(nodePath);
        sb.append(SELECT_QUERY);
        if (pathPattern.length() > 0) {
            sb.append(pathPattern).append(" AND ");
        }
        sb.append("(" + this.buildDocumentTypePattern(repository) + ")").append(" AND ").append(" (exo:dateModified >= TIMESTAMP '" + strBeginningOfThisMonthTime + "')").append(" AND ").append(" (exo:dateModified < TIMESTAMP '" + strBeginningOfThisWeekTime + "')");
        if (byUser) {
            sb.append(" AND ").append(" (exo:owner = '" + userName + "')");
        }
        sb.append(" ORDER BY ").append(EXO_MODIFIED_DATE);
        QueryResult result = this.executeQuery(session, sb.toString(), "sql");
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            documentsOfMonth.add(nodeIter.nextNode());
        }
        return documentsOfMonth;
    }

    @Override
    public List<Node> getDocumentsOfEarlierThisWeek(String nodePath, String repository, String workspace, SessionProvider sessionProvider, String userName, boolean byUser) throws Exception {
        ArrayList<Node> documentsOfWeek = new ArrayList<Node>();
        Session session = this.getSession(sessionProvider, repository, workspace);
        GregorianCalendar currentTime = new GregorianCalendar();
        String strYesterdayTime = this.getStrYesterdayTime(currentTime);
        String strBeginningOfThisWeekTime = this.getStrBeginningOfThisWeekTime(currentTime);
        StringBuilder sb = new StringBuilder();
        String pathPattern = this.buildPathPattern(nodePath);
        sb.append(SELECT_QUERY);
        if (pathPattern.length() > 0) {
            sb.append(pathPattern).append(" AND ");
        }
        sb.append("(" + this.buildDocumentTypePattern(repository) + ")").append(" AND ").append(" (exo:dateModified >= TIMESTAMP '" + strBeginningOfThisWeekTime + "')").append(" AND ").append(" (exo:dateModified < TIMESTAMP '" + strYesterdayTime + "')");
        if (byUser) {
            sb.append(" AND ").append(" (exo:owner = '" + userName + "')");
        }
        sb.append(" ORDER BY ").append(EXO_MODIFIED_DATE);
        QueryResult result = this.executeQuery(session, sb.toString(), "sql");
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            documentsOfWeek.add(nodeIter.nextNode());
        }
        return documentsOfWeek;
    }

    @Override
    public List<Node> getDocumentsOfYesterday(String nodePath, String repository, String workspace, SessionProvider sessionProvider, String userName, boolean byUser) throws Exception {
        ArrayList<Node> documentsOfYesterday = new ArrayList<Node>();
        Session session = this.getSession(sessionProvider, repository, workspace);
        GregorianCalendar currentTime = new GregorianCalendar();
        String strTodayTime = this.getStrTodayTime(currentTime);
        String strYesterdayTime = this.getStrYesterdayTime(currentTime);
        StringBuilder sb = new StringBuilder();
        String pathPattern = this.buildPathPattern(nodePath);
        sb.append(SELECT_QUERY);
        if (pathPattern.length() > 0) {
            sb.append(pathPattern).append(" AND ");
        }
        sb.append("(" + this.buildDocumentTypePattern(repository) + ")").append(" AND ").append(" (exo:dateModified >= TIMESTAMP '" + strYesterdayTime + "')").append(" AND ").append(" (exo:dateModified < TIMESTAMP '" + strTodayTime + "')");
        if (byUser) {
            sb.append(" AND ").append(" (exo:owner = '" + userName + "')");
        }
        sb.append(" ORDER BY ").append(EXO_MODIFIED_DATE);
        QueryResult result = this.executeQuery(session, sb.toString(), "sql");
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            documentsOfYesterday.add(nodeIter.nextNode());
        }
        return documentsOfYesterday;
    }

    @Override
    public List<Node> getDocumentsOfToday(String nodePath, String repository, String workspace, SessionProvider sessionProvider, String userName, boolean byUser) throws Exception {
        ArrayList<Node> documentsOfToday = new ArrayList<Node>();
        Session session = this.getSession(sessionProvider, repository, workspace);
        GregorianCalendar currentTime = new GregorianCalendar();
        String strTodayTime = this.getStrTodayTime(currentTime);
        StringBuilder sb = new StringBuilder();
        String pathPattern = this.buildPathPattern(nodePath);
        sb.append(SELECT_QUERY);
        if (pathPattern.length() > 0) {
            sb.append(pathPattern).append(" AND ");
        }
        sb.append("(" + this.buildDocumentTypePattern(repository) + ")").append(" AND ").append(" (exo:dateModified >= TIMESTAMP '" + strTodayTime + "')");
        if (byUser) {
            sb.append(" AND ").append(" (exo:owner = '" + userName + "')");
        }
        sb.append(" ORDER BY ").append(EXO_MODIFIED_DATE).append(" DESC");
        QueryResult result = this.executeQuery(session, sb.toString(), "sql");
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            documentsOfToday.add(nodeIter.nextNode());
        }
        return documentsOfToday;
    }

    private Session getSession(SessionProvider sessionProvider, String repository, String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        return sessionProvider.getSession(workspace, manageableRepository);
    }

    private QueryResult executeQuery(Session session, String statement, String language) throws Exception {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)queryManager.createQuery(statement, language);
            query.setLimit((long)this.itemPerTimeline);
            return query.execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not execute query", (Throwable)e);
            return null;
        }
    }

    private String buildDocumentTypePattern(String repository) throws Exception {
        List<String> documentFileTypes = this.templateService_.getAllDocumentNodeTypes(repository);
        StringBuilder sb = new StringBuilder();
        for (String documentType : documentFileTypes) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("jcr:primaryType='" + documentType + "'");
        }
        return sb.toString();
    }

    private String getStrTodayTime(Calendar time) {
        String currentDate = formatDateTime.format(time.getTime());
        return currentDate + TIME_FORMAT_TAIL;
    }

    private String buildPathPattern(String nodePath) {
        if (nodePath.equals("/")) {
            return "";
        }
        return "jcr:path LIKE '" + nodePath + "/%" + "'";
    }

    private String getStrYesterdayTime(Calendar time) {
        Calendar yesterday = (Calendar)time.clone();
        yesterday.add(5, -1);
        String yesterdayDate = formatDateTime.format(yesterday.getTime());
        return yesterdayDate + TIME_FORMAT_TAIL;
    }

    private String getStrBeginningOfThisWeekTime(Calendar time) {
        Calendar monday = (Calendar)time.clone();
        while (monday.get(3) == time.get(3)) {
            monday.add(5, -1);
        }
        monday.add(5, 1);
        String mondayDate = formatDateTime.format(monday.getTime());
        return mondayDate + TIME_FORMAT_TAIL;
    }

    private String getStrBeginningOfThisMonthTime(Calendar time) {
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), time.get(2), 1, 0, 0, 0);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL;
    }

    private String getStrBeginningOfThisYearTime(Calendar time) {
        Calendar theFirst = (Calendar)time.clone();
        theFirst.set(time.get(1), 0, 1, 0, 0, 0);
        String theFirstDate = formatDateTime.format(theFirst.getTime());
        return theFirstDate + TIME_FORMAT_TAIL;
    }

    static {
        formatDateTime.applyPattern("yyyy-MM-dd");
    }
}

