/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Serialization<T> {
    public static final Serialization<Map<String, String[]>> PARAMETER_MAP = new Serialization<Map<String, String[]>>(){

        @Override
        public void serialize(Map<String, String[]> map, OutputStream out) throws IOException, IllegalArgumentException {
            if (map == null) {
                throw new IllegalArgumentException("No null map allowed");
            }
            DataOutputStream data = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
            data.writeInt(map.size());
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String name = entry.getKey();
                data.writeUTF(name);
                String[] values = entry.getValue();
                if (values == null) {
                    throw new IllegalArgumentException("No null values are allowed in the map");
                }
                int length = values.length;
                data.writeInt(length);
                for (String value : values) {
                    if (value == null) {
                        throw new IllegalArgumentException("No null value in the String[] are allowed in the map");
                    }
                    data.writeUTF(value);
                }
            }
            data.flush();
        }

        @Override
        public Map<String, String[]> unserialize(InputStream in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException("No null input stream");
            }
            DataInputStream data = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
            int size = data.readInt();
            HashMap<String, String[]> tmp = new HashMap<String, String[]>(size);
            while (size-- > 0) {
                String name = data.readUTF();
                int length = data.readInt();
                String[] values = new String[length];
                for (int i = 0; i < length; ++i) {
                    values[i] = data.readUTF();
                }
                tmp.put(name, values);
            }
            return tmp;
        }
    };

    public void serialize(T var1, OutputStream var2) throws IOException, IllegalArgumentException;

    public T unserialize(InputStream var1) throws IOException, IllegalArgumentException;
}

