/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.definition;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.definition.PortalContainerDefinition;
import org.exoplatform.container.definition.PortalContainerDefinitionChange;
import org.exoplatform.container.definition.PortalContainerDefinitionChangePlugin;
import org.exoplatform.container.definition.PortalContainerDefinitionDisablePlugin;
import org.exoplatform.container.definition.PortalContainerDefinitionPlugin;
import org.exoplatform.container.definition.SafePortalContainerDefinition;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalContainerConfig
implements Startable {
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.container.PortalContainerConfig");
    public static final String PORTAL_CONTAINER_SETTING_NAME = "name";
    public static final String REST_CONTEXT_SETTING_NAME = "rest";
    public static final String REALM_SETTING_NAME = "realm";
    public static final String DEFAULT_PORTAL_CONTAINER_NAME = new String("portal");
    public static final String DEFAULT_REST_CONTEXT_NAME = new String("rest");
    public static final String DEFAULT_REALM_NAME = new String("exo-domain");
    private final PortalContainerDefinition defaultDefinition;
    private volatile boolean initialized;
    private Set<String> portalContainerNames = Collections.unmodifiableSet(new HashSet());
    private Set<String> portalContainerNamesDisabled = Collections.unmodifiableSet(new HashSet());
    private Map<String, List<String>> scopes = Collections.unmodifiableMap(new HashMap());
    private Map<String, PortalContainerDefinition> definitions = Collections.unmodifiableMap(new HashMap());
    private List<PortalContainerDefinitionChangePlugin> changes = new ArrayList<PortalContainerDefinitionChangePlugin>();
    private final ConfigurationManager cm;
    private final J2EEServerInfo serverInfo;
    private final PropertyConfigurator pc;

    public PortalContainerConfig(ConfigurationManager cm) {
        this(null, cm, new J2EEServerInfo(), null);
    }

    public PortalContainerConfig(ConfigurationManager cm, PropertyConfigurator pc) {
        this(null, cm, new J2EEServerInfo(), pc);
    }

    public PortalContainerConfig(ConfigurationManager cm, J2EEServerInfo serverInfo) {
        this(null, cm, serverInfo, null);
    }

    public PortalContainerConfig(ConfigurationManager cm, J2EEServerInfo serverInfo, PropertyConfigurator pc) {
        this(null, cm, serverInfo, pc);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm) {
        this(params, cm, new J2EEServerInfo(), null);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, PropertyConfigurator pc) {
        this(params, cm, new J2EEServerInfo(), pc);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, J2EEServerInfo serverInfo) {
        this(params, cm, serverInfo, null);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, J2EEServerInfo serverInfo, PropertyConfigurator pc) {
        this.pc = pc;
        this.cm = cm;
        this.serverInfo = serverInfo;
        this.defaultDefinition = this.create(params);
    }

    private PortalContainerDefinition create(InitParams params) {
        ObjectParameter oDpd = null;
        if (params != null) {
            oDpd = params.getObjectParam("default.portal.definition");
        }
        PortalContainerDefinition def = null;
        if (oDpd != null) {
            Object o = oDpd.getObject();
            if (o instanceof PortalContainerDefinition) {
                def = (PortalContainerDefinition)o;
            } else {
                log.warn((Object)("The object parameter 'default.portal.definition' should be of type " + PortalContainerDefinition.class));
            }
        }
        if (def == null) {
            def = new PortalContainerDefinition();
        }
        this.initName(params, def);
        this.initRestContextName(params, def);
        this.initRealmName(params, def);
        this.initializeSettings(def, false);
        return def;
    }

    private void initRealmName(InitParams params, PortalContainerDefinition def) {
        if (def.getRealmName() == null || def.getRealmName().trim().length() == 0) {
            def.setRealmName(DEFAULT_REALM_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.realm.name");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setRealmName(vp.getValue().trim());
            }
        } else {
            def.setRealmName(def.getRealmName().trim());
        }
    }

    private void initRestContextName(InitParams params, PortalContainerDefinition def) {
        if (def.getRestContextName() == null || def.getRestContextName().trim().length() == 0) {
            def.setRestContextName(DEFAULT_REST_CONTEXT_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.rest.context");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setRestContextName(vp.getValue().trim());
            }
        } else {
            def.setRestContextName(def.getRestContextName().trim());
        }
    }

    private void initName(InitParams params, PortalContainerDefinition def) {
        if (def.getName() == null || def.getName().trim().length() == 0) {
            def.setName(DEFAULT_PORTAL_CONTAINER_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.portal.container");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setName(vp.getValue().trim());
            }
        } else {
            def.setName(def.getName().trim());
        }
    }

    public String getDefaultPortalContainer() {
        return this.defaultDefinition.getName();
    }

    public String getDefaultRestContext() {
        return this.defaultDefinition.getRestContextName();
    }

    public String getDefaultRealmName() {
        return this.defaultDefinition.getRealmName();
    }

    public boolean hasDefinition() {
        return !this.definitions.isEmpty();
    }

    public synchronized void disablePortalContainer(String name) {
        if (!this.portalContainerNamesDisabled.contains(name)) {
            if (PropertyManager.isDevelopping()) {
                log.info((Object)("The portal container '" + name + "' will be disabled"));
            }
            HashSet<String> lPortalContainerNames = new HashSet<String>(this.portalContainerNamesDisabled.size() + 1);
            lPortalContainerNames.add(name);
            lPortalContainerNames.addAll(this.portalContainerNamesDisabled);
            this.portalContainerNamesDisabled = Collections.unmodifiableSet(lPortalContainerNames);
            if (this.hasDefinition()) {
                this.unregisterPortalContainerName(name);
            }
        }
    }

    private void removePortalContainerNameFromScopes(String name) {
        HashMap<String, List<String>> tmpScopes = new HashMap<String, List<String>>(this.scopes);
        boolean changed = false;
        for (String ctx : tmpScopes.keySet()) {
            List portalContainerNames = (List)tmpScopes.get(ctx);
            if (!portalContainerNames.contains(name)) continue;
            ArrayList tmpPortalContainerNames = new ArrayList(portalContainerNames);
            tmpPortalContainerNames.remove(name);
            tmpScopes.put(ctx, Collections.unmodifiableList(tmpPortalContainerNames));
            changed = true;
        }
        if (changed) {
            this.scopes = Collections.unmodifiableMap(tmpScopes);
        }
    }

    public boolean isPortalContainerNameDisabled(String name) {
        return name == null ? false : this.portalContainerNamesDisabled.contains(name);
    }

    public synchronized void registerPortalContainerName(String name) {
        if (!this.portalContainerNames.contains(name)) {
            LinkedHashSet<String> lPortalContainerNames = new LinkedHashSet<String>(this.portalContainerNames.size() + 1);
            lPortalContainerNames.add(name);
            lPortalContainerNames.addAll(this.portalContainerNames);
            this.portalContainerNames = Collections.unmodifiableSet(lPortalContainerNames);
        }
    }

    public synchronized void unregisterPortalContainerName(String name) {
        if (this.portalContainerNames.contains(name)) {
            LinkedHashSet<String> lPortalContainerNames = new LinkedHashSet<String>(this.portalContainerNames);
            lPortalContainerNames.remove(name);
            this.portalContainerNames = Collections.unmodifiableSet(lPortalContainerNames);
            if (this.hasDefinition()) {
                this.removePortalContainerNameFromScopes(name);
            }
        }
    }

    public boolean isPortalContainerName(String name) {
        return name == null ? false : this.portalContainerNames.contains(name);
    }

    public List<String> getPortalContainerNames(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        if (this.definitions.isEmpty()) {
            String portalContainerName = this.portalContainerNames.contains(contextName) ? contextName : this.defaultDefinition.getName();
            return Collections.singletonList(portalContainerName);
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            if (this.portalContainerNames.contains(contextName)) {
                return Collections.singletonList(contextName);
            }
            return Collections.emptyList();
        }
        return result;
    }

    public String getPortalContainerName(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        if (this.portalContainerNames.contains(contextName)) {
            return contextName;
        }
        if (this.definitions.isEmpty()) {
            return this.defaultDefinition.getName();
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            if (PropertyManager.isDevelopping()) {
                log.info((Object)("The context '" + contextName + "' has not been added as " + "dependency of any portal containers"));
            }
            return null;
        }
        return result.get(0);
    }

    public List<String> getDependencies(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition != null) {
            List<String> result = definition.getDependencies();
            return result == null || result.isEmpty() ? this.defaultDefinition.getDependencies() : result;
        }
        if (this.definitions.isEmpty()) {
            return this.defaultDefinition.getDependencies();
        }
        return null;
    }

    public Object getSetting(String portalContainerName, String settingName) {
        Map<String, Object> settings;
        if (settingName == null) {
            throw new IllegalArgumentException("The setting name cannot be null");
        }
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition != null && (settings = definition.getSettings()) != null && !settings.isEmpty()) {
            return settings.get(settingName);
        }
        Map<String, Object> defaultSettings = this.defaultDefinition.getSettings();
        return defaultSettings == null ? null : defaultSettings.get(settingName);
    }

    public String getRestContextName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultDefinition.getRestContextName();
        }
        String contextName = definition.getRestContextName();
        return contextName == null ? this.defaultDefinition.getRestContextName() : contextName;
    }

    public String getRealmName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultDefinition.getRealmName();
        }
        String realmName = definition.getRealmName();
        return realmName == null ? this.defaultDefinition.getRealmName() : realmName;
    }

    public boolean isScopeValid(String portalContainerName, String contextName) {
        if (portalContainerName == null) {
            throw new IllegalArgumentException("The portal container name cannot be null");
        }
        return this.getPortalContainerNames(contextName).contains(portalContainerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(PortalContainerDefinitionPlugin plugin) {
        List<PortalContainerDefinition> lDefs = plugin.getPortalContainerDefinitions();
        if (lDefs != null && !lDefs.isEmpty()) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    throw new IllegalStateException("The PortalContainerConfig has already been initialized");
                }
                LinkedHashMap<String, PortalContainerDefinition> tempDefinitions = new LinkedHashMap<String, PortalContainerDefinition>(this.definitions);
                for (PortalContainerDefinition def : lDefs) {
                    String name = def.getName();
                    if (name == null || (name = name.trim()).length() == 0) {
                        log.warn((Object)"A PortalContainerDefinition cannot have an empty name");
                        continue;
                    }
                    def.setName(name);
                    tempDefinitions.put(name, def);
                }
                this.definitions = Collections.unmodifiableMap(tempDefinitions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisablePlugin(PortalContainerDefinitionDisablePlugin plugin) {
        Set<String> sPortalContainerNames = plugin.getNames();
        if (sPortalContainerNames != null && !sPortalContainerNames.isEmpty()) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    throw new IllegalStateException("The PortalContainerConfig has already been initialized");
                }
                for (String name : sPortalContainerNames) {
                    this.disablePortalContainer(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangePlugin(PortalContainerDefinitionChangePlugin plugin) {
        List<PortalContainerDefinitionChange> lchanges = plugin.getChanges();
        if (lchanges != null && !lchanges.isEmpty()) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    throw new IllegalStateException("The PortalContainerConfig has already been initialized");
                }
                this.changes.add(plugin);
            }
        }
    }

    private void registerDependencies(PortalContainerDefinition definition, Map<String, List<String>> scopes) {
        List<String> dependencies = definition.getDependencies();
        if ((dependencies == null || dependencies.isEmpty()) && ((dependencies = this.defaultDefinition.getDependencies()) == null || dependencies.isEmpty())) {
            return;
        }
        for (String context : dependencies) {
            if (context == null || (context = context.trim()).length() == 0) continue;
            List<String> lPortalContainerNames = scopes.get(context);
            lPortalContainerNames = lPortalContainerNames == null ? new ArrayList<String>() : new ArrayList<String>(lPortalContainerNames);
            lPortalContainerNames.add(definition.getName());
            scopes.put(context, Collections.unmodifiableList(lPortalContainerNames));
        }
    }

    private void initializeSettings(PortalContainerDefinition def, boolean addDefaultSettings) {
        PortalContainerDefinition[] defs = addDefaultSettings ? new PortalContainerDefinition[]{this.defaultDefinition, def} : new PortalContainerDefinition[]{def};
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.loadInternalSettings(defs, settings);
        if (this.pc != null) {
            this.resolveInternalSettings(settings);
        }
        LinkedHashMap<String, String> externalSettings = new LinkedHashMap<String, String>();
        this.loadExternalSettings(def, defs, externalSettings);
        if (!externalSettings.isEmpty()) {
            this.resolveExternalSettings(def, settings, externalSettings);
            this.mergeSettings(settings, externalSettings);
        }
        settings.putAll(this.getMainSettings(def));
        def.setSettings(Collections.unmodifiableMap(settings));
    }

    private void resolveExternalSettings(PortalContainerDefinition def, Map<String, Object> settings, Map<String, String> externalSettings) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        ctx.putAll(settings);
        ctx.putAll(externalSettings);
        ctx.putAll(this.getMainSettings(def));
        for (Map.Entry<String, String> entry : externalSettings.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            propertyValue = Deserializer.resolveVariables(propertyValue, ctx);
            externalSettings.put(propertyName, propertyValue);
            ctx.put(propertyName, propertyValue);
        }
    }

    private void loadExternalSettings(PortalContainerDefinition def, PortalContainerDefinition[] defs, Map<String, String> externalSettings) {
        for (PortalContainerDefinition pcd : defs) {
            Map<String, String> props;
            String path = pcd.getExternalSettingsPath();
            if (path == null || (path = path.trim()).length() <= 0 || (props = this.loadExternalSettings(path, this.defaultDefinition == null || pcd == this.defaultDefinition, def)) == null || props.isEmpty()) continue;
            externalSettings.putAll(props);
        }
    }

    private void resolveInternalSettings(Map<String, Object> settings) {
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (!(propertyValue instanceof String)) continue;
            propertyValue = Deserializer.resolveVariables((String)propertyValue);
            settings.put(propertyName, propertyValue);
        }
    }

    private void loadInternalSettings(PortalContainerDefinition[] defs, Map<String, Object> settings) {
        for (PortalContainerDefinition pcd : defs) {
            Map<String, Object> tmpSettings = pcd.getSettings();
            if (tmpSettings == null || tmpSettings.isEmpty()) continue;
            settings.putAll(tmpSettings);
        }
    }

    private Map<String, String> getMainSettings(PortalContainerDefinition def) {
        HashMap<String, String> settings = new HashMap<String, String>(3);
        settings.put(PORTAL_CONTAINER_SETTING_NAME, def.getName());
        settings.put(REST_CONTEXT_SETTING_NAME, def.getRestContextName() == null ? this.defaultDefinition.getRestContextName() : def.getRestContextName());
        settings.put(REALM_SETTING_NAME, def.getRealmName() == null ? this.defaultDefinition.getRealmName() : def.getRealmName());
        return settings;
    }

    private Map<String, String> loadExternalSettings(String path, boolean isPath4DefaultPCD, PortalContainerDefinition def) {
        try {
            URL url = null;
            if (path.indexOf(58) == -1) {
                String fullPath = this.serverInfo.getExoConfigurationDirectory() + "/portal/" + (isPath4DefaultPCD ? "" : def.getName() + "/") + path;
                File file = new File(fullPath);
                if (file.exists()) {
                    url = file.toURI().toURL();
                    if (ConfigurationManager.LOG_DEBUG) {
                        log.info((Object)("The external settings could be found in the directory ${exo-conf}/portal, it will be used as external settings of the " + (isPath4DefaultPCD ? "default portal container" : "portal container '" + def.getName() + "'")));
                    }
                } else if (ConfigurationManager.LOG_DEBUG) {
                    log.info((Object)("No external settings could be found in the directory ${exo-conf}/portal for the " + (isPath4DefaultPCD ? "default portal container" : "portal container '" + def.getName() + "'")));
                }
            }
            if (url == null) {
                url = this.cm.getURL(path);
                if (ConfigurationManager.LOG_DEBUG) {
                    log.info((Object)("Trying to retrieve the external settings from the url '" + url + "', it will be used as external settings of the " + (isPath4DefaultPCD ? "default portal container" : "portal container '" + def.getName() + "'")));
                }
            }
            return ContainerUtil.loadProperties(url, false);
        }
        catch (Exception e) {
            log.error((Object)("Cannot load property file " + path), (Throwable)e);
            return null;
        }
    }

    private void mergeSettings(Map<String, Object> settings, Map<String, String> props) {
        if (settings.isEmpty()) {
            settings.putAll(props);
        } else {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String propertyName = entry.getKey();
                Object propertyValue = entry.getValue();
                if ((propertyValue = Deserializer.resolveString((String)propertyValue)) == null) continue;
                Object oldValue = settings.get(propertyName);
                if (oldValue != null) {
                    Method m;
                    block9: {
                        m = null;
                        try {
                            m = oldValue.getClass().getMethod("valueOf", String.class);
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug((Object)("The static method valueOf(String) cannot be found for the class " + oldValue.getClass()), (Throwable)e);
                        }
                    }
                    if (m != null) {
                        String sPropertyValue = ((String)propertyValue).trim();
                        if (sPropertyValue.length() == 0) continue;
                        try {
                            propertyValue = m.invoke(null, propertyValue);
                        }
                        catch (Exception e) {
                            log.error((Object)("Cannot convert the value '" + propertyValue + "' to an Object of type " + oldValue.getClass()), (Throwable)e);
                            continue;
                        }
                    }
                }
                settings.put(propertyName, propertyValue);
            }
        }
    }

    private void initialize(Map<String, PortalContainerDefinition> mDefinitions) {
        LinkedHashSet<String> lPortalContainerNames = new LinkedHashSet<String>(mDefinitions.size() + 1);
        HashMap<String, List<String>> mScopes = new HashMap<String, List<String>>();
        boolean first = true;
        for (Map.Entry<String, PortalContainerDefinition> entry : mDefinitions.entrySet()) {
            PortalContainerDefinition definition = entry.getValue();
            String name = definition.getName();
            if (this.isPortalContainerNameDisabled(name)) continue;
            boolean hasChanged = false;
            lPortalContainerNames.add(name);
            if (first) {
                first = false;
                if (this.defaultDefinition.getName() == DEFAULT_PORTAL_CONTAINER_NAME) {
                    this.defaultDefinition.setName(name);
                    hasChanged = true;
                }
                if (this.defaultDefinition.getRestContextName() == DEFAULT_REST_CONTEXT_NAME && definition.getRestContextName() != null && definition.getRestContextName().trim().length() > 0) {
                    this.defaultDefinition.setRestContextName(definition.getRestContextName().trim());
                    hasChanged = true;
                }
                if (this.defaultDefinition.getRealmName() == DEFAULT_REALM_NAME && definition.getRealmName() != null && definition.getRealmName().trim().length() > 0) {
                    this.defaultDefinition.setRealmName(definition.getRealmName().trim());
                    hasChanged = true;
                }
            }
            this.applyChanges(definition);
            this.registerDependencies(definition, mScopes);
            if (hasChanged) {
                this.initializeSettings(this.defaultDefinition, false);
            }
            this.initializeSettings(definition, true);
        }
        if (mDefinitions.isEmpty()) {
            lPortalContainerNames.add(this.defaultDefinition.getName());
            this.applyChanges(this.defaultDefinition);
            this.initializeSettings(this.defaultDefinition, false);
            if (this.defaultDefinition.getDependencies() != null && !this.defaultDefinition.getDependencies().isEmpty()) {
                this.registerDependencies(this.defaultDefinition, mScopes);
            }
            if (!this.portalContainerNamesDisabled.isEmpty()) {
                if (PropertyManager.isDevelopping()) {
                    log.warn((Object)"No portal container definition has been registered, the old behavior is then expected so you cannot disable any portal container. The list of portal containers to disable will be ignored");
                }
                this.portalContainerNamesDisabled = Collections.unmodifiableSet(new HashSet());
            }
        }
        this.portalContainerNames = Collections.unmodifiableSet(lPortalContainerNames);
        this.scopes = Collections.unmodifiableMap(mScopes);
        this.changes.clear();
    }

    private void applyChanges(PortalContainerDefinition definition) {
        for (PortalContainerDefinitionChangePlugin plugin : this.changes) {
            if (!this.matches(definition, plugin)) continue;
            for (PortalContainerDefinitionChange change : plugin.getChanges()) {
                try {
                    change.apply(new SafePortalContainerDefinition(definition, this.defaultDefinition));
                }
                catch (Exception e) {
                    log.warn((Object)("Cannot apply the change " + change), (Throwable)e);
                }
            }
        }
    }

    private boolean matches(PortalContainerDefinition definition, PortalContainerDefinitionChangePlugin plugin) {
        if (plugin.isAll()) {
            return true;
        }
        if ((plugin.getNames() == null || plugin.isDefault()) && this.defaultDefinition.getName().equals(definition.getName())) {
            return true;
        }
        return plugin.getNames() != null && plugin.getNames().contains(definition.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    return;
                }
                this.initialized = true;
            }
        } else {
            return;
        }
        this.initialize(this.definitions);
    }

    public void stop() {
    }
}

