/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractHttpSessionListener
implements HttpSessionListener {
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.container.AbstractHttpSessionListener");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sessionCreated(HttpSessionEvent event) {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer(event);
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            if (this.requirePortalEnvironment()) {
                String ctxName = event.getSession().getServletContext().getServletContextName();
                if (!PortalContainer.isPortalContainerNameDisabled(ctxName) && container instanceof PortalContainer) {
                    if (PortalContainer.getInstanceIfPresent() == null) {
                        PortalContainer.setInstance((PortalContainer)container);
                        hasBeenSet = true;
                    }
                    Thread.currentThread().setContextClassLoader(((PortalContainer)container).getPortalClassLoader());
                } else {
                    if (PropertyManager.isDevelopping()) {
                        log.info((Object)("The portal environment could not be set for the webapp '" + ctxName + "' because this servlet context has not been defined as a " + "dependency of any portal container or it is a disabled portal" + " container, the sessionCreated event will be ignored"));
                    }
                    return;
                }
            }
            this.onSessionCreated(container, event);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
            if (this.requirePortalEnvironment()) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sessionDestroyed(HttpSessionEvent event) {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer(event);
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            if (this.requirePortalEnvironment()) {
                String ctxName = event.getSession().getServletContext().getServletContextName();
                if (!PortalContainer.isPortalContainerNameDisabled(ctxName) && container instanceof PortalContainer) {
                    if (PortalContainer.getInstanceIfPresent() == null) {
                        PortalContainer.setInstance((PortalContainer)container);
                        hasBeenSet = true;
                    }
                    Thread.currentThread().setContextClassLoader(((PortalContainer)container).getPortalClassLoader());
                } else {
                    if (PropertyManager.isDevelopping()) {
                        log.info((Object)("The portal environment could not be set for the webapp '" + ctxName + "' because this servlet context has not been defined as a " + "dependency of any portal container or it is a disabled portal" + " container, the sessionDestroyed event will be ignored"));
                    }
                    return;
                }
            }
            this.onSessionDestroyed(container, event);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
            if (this.requirePortalEnvironment()) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected abstract boolean requirePortalEnvironment();

    protected abstract void onSessionCreated(ExoContainer var1, HttpSessionEvent var2);

    protected abstract void onSessionDestroyed(ExoContainer var1, HttpSessionEvent var2);

    protected final ExoContainer getContainer(HttpSessionEvent event) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance(event.getSession().getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }
}

