/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPortalNavigationExplorer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationHistory;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPages;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPagesContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationTree;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublishClvChooser;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublishedPages;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublicationAction.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class})})
public class UIPublicationAction
extends UIForm {
    public void updateUI() throws Exception {
        UIPublicationPages publicationPages = (UIPublicationPages)this.getAncestorOfType(UIPublicationPages.class);
        UIPublishedPages publishedPages = (UIPublishedPages)publicationPages.getChild(UIPublishedPages.class);
        Node node = publicationPages.getNode();
        ArrayList<String> listPublishedPage = new ArrayList<String>();
        if (node.hasProperty("publication:navigationNodeURIs")) {
            Value[] navigationNodeURIs;
            for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                if (!PublicationUtil.isNodeContentPublishedToPageNode((Node)node, (String)navigationNodeURI.getString())) continue;
                listPublishedPage.add(navigationNodeURI.getString());
            }
            publishedPages.setListNavigationNodeURI(listPublishedPage);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
            UIPublicationHistory publicationHistory = (UIPublicationHistory)publicationContainer.getChild(UIPublicationHistory.class);
            UIPublicationPanel publicationPanel = (UIPublicationPanel)publicationContainer.getChild(UIPublicationPanel.class);
            publicationHistory.init(publicationPanel.getCurrentNode());
            publicationHistory.updateGrid();
        }
    }

    private static List<String> getManualModeCLVPortletIDs(Page page) throws Exception {
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        List clvPortletsId = PublicationUtil.findAppInstancesByName((Page)page, (String)wcmConfigurationService.getRuntimeContextParam("CLVPortlet"));
        ArrayList<String> applicationIDs = new ArrayList<String>();
        for (String clvPortletId : clvPortletsId) {
            boolean isManualViewerMode = false;
            PortletPreferences portletPreferences = dataStorage.getPortletPreferences(clvPortletId);
            if (portletPreferences != null) {
                for (Preference object : portletPreferences.getPreferences()) {
                    Preference preference = object;
                    if (!"mode".equals(preference.getName()) || preference.getValues().size() <= 0) continue;
                    isManualViewerMode = "ManualViewerMode".equals(((String)preference.getValues().get(0)).toString());
                }
            }
            if (!isManualViewerMode) continue;
            applicationIDs.add(clvPortletId);
        }
        return applicationIDs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublicationPages publicationPages = (UIPublicationPages)publicationAction.getAncestorOfType(UIPublicationPages.class);
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)publicationAction.getApplicationComponent(UserPortalConfigService.class);
            UIPublishedPages publishedPages = (UIPublishedPages)publicationPages.getChild(UIPublishedPages.class);
            DataStorage dataStorage = (DataStorage)publicationAction.getApplicationComponent(DataStorage.class);
            String selectedNavigationNodeURI = publishedPages.getSelectedNavigationNodeURI();
            if (selectedNavigationNodeURI == null) {
                UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            String portalName = selectedNavigationNodeURI.substring(1, selectedNavigationNodeURI.indexOf("/", 1));
            String pageNodeUri = selectedNavigationNodeURI.replaceFirst("/\\w+/", "");
            PageNavigation pageNavigation = null;
            Page page = null;
            Query query = new Query("portal", portalName, PageNavigation.class);
            List pageNavigations = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)dataStorage.find2(query));
            Iterator i$ = pageNavigations.iterator();
            while (i$.hasNext()) {
                PageNavigation object;
                pageNavigation = object = (PageNavigation)i$.next();
            }
            Node contentNode = null;
            if (pageNavigation != null && (contentNode = publicationPages.getNode()).hasProperty("publication:applicationIDs")) {
                PageNode pageNode = this.getPageNodeByUri(pageNavigation, pageNodeUri);
                page = userPortalConfigService.getPage(pageNode.getPageReference(), event.getRequestContext().getRemoteUser());
            }
            WCMPublicationService presentationService = (WCMPublicationService)publicationAction.getApplicationComponent(WCMPublicationService.class);
            StageAndVersionPublicationPlugin publicationPlugin = (StageAndVersionPublicationPlugin)((Object)presentationService.getWebpagePublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME));
            publicationPlugin.suspendPublishedContentFromPage(publicationPages.getNode(), page, event.getRequestContext().getRemoteUser());
            publicationAction.updateUI();
            UIPublicationPagesContainer publicationPagesContainer = (UIPublicationPagesContainer)publicationPages.getAncestorOfType(UIPublicationPagesContainer.class);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationAction.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPagesContainer, event.getRequestContext());
        }

        private PageNode getPageNodeByUri(PageNavigation pageNav, String uri) {
            if (pageNav == null || uri == null) {
                return null;
            }
            ArrayList pageNodes = pageNav.getNodes();
            for (PageNode pageNode : pageNodes) {
                PageNode returnPageNode = this.getPageNodeByUri(pageNode, uri);
                if (returnPageNode == null) continue;
                return returnPageNode;
            }
            return null;
        }

        private PageNode getPageNodeByUri(PageNode pageNode, String uri) {
            if (pageNode.getUri().equals(uri)) {
                return pageNode;
            }
            List children = pageNode.getChildren();
            if (children == null) {
                return null;
            }
            for (PageNode ele : children) {
                PageNode returnPageNode = this.getPageNodeByUri(ele, uri);
                if (returnPageNode == null) continue;
                return returnPageNode;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            PageNode pageNode;
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublicationPages publicationPages = (UIPublicationPages)publicationAction.getAncestorOfType(UIPublicationPages.class);
            UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
            UIPortalNavigationExplorer portalNavigationExplorer = (UIPortalNavigationExplorer)publicationPages.getChild(UIPortalNavigationExplorer.class);
            UIPublicationTree.TreeNode selectedNode = portalNavigationExplorer.getSelectedNode();
            if (selectedNode == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            String selectedNavigationNodeURI = selectedNode.getUri();
            Node node = publicationPages.getNode();
            if (node.hasProperty("publication:navigationNodeURIs") && PublicationUtil.isNodeContentPublishedToPageNode((Node)node, (String)selectedNavigationNodeURI)) {
                Value[] navigationNodeURIs;
                for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                    if (!navigationNodeURI.getString().equals(selectedNavigationNodeURI)) continue;
                    application.addMessage(new ApplicationMessage("UIPublicationAction.msg.duplicate", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                    return;
                }
            }
            if ((pageNode = selectedNode.getPageNode()) == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.wrongNode", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            WCMPublicationService presentationService = (WCMPublicationService)publicationAction.getApplicationComponent(WCMPublicationService.class);
            UIPublicationPagesContainer publicationPagesContainer = (UIPublicationPagesContainer)publicationPages.getAncestorOfType(UIPublicationPagesContainer.class);
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)publicationAction.getApplicationComponent(UserPortalConfigService.class);
            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), event.getRequestContext().getRemoteUser());
            List clvPortletIds = UIPublicationAction.getManualModeCLVPortletIDs(page);
            if (clvPortletIds.isEmpty()) {
                presentationService.publishContentSCV(node, page, Util.getUIPortal().getOwner());
            } else if (clvPortletIds.size() > 1) {
                UIPublishClvChooser clvChooser = (UIPublishClvChooser)publicationAction.createUIComponent(UIPublishClvChooser.class, null, "UIPublishClvChooser");
                clvChooser.setPage(page);
                clvChooser.setNode(node);
                UIPopupWindow popupWindow = (UIPopupWindow)publicationPagesContainer.getChildById("UIClvPopupContainer");
                clvChooser.setRendered(true);
                popupWindow.setUIComponent((UIComponent)clvChooser);
                popupWindow.setWindowSize(400, -1);
                popupWindow.setShow(true);
                popupWindow.setShowMask(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)publicationPagesContainer);
            } else {
                String clvPortletId = (String)clvPortletIds.get(0);
                presentationService.publishContentCLV(node, page, clvPortletId, Util.getUIPortal().getOwner(), event.getRequestContext().getRemoteUser());
            }
            publicationAction.updateUI();
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationAction.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPagesContainer, event.getRequestContext());
        }
    }
}

