/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.storage;

import java.io.IOException;
import org.exoplatform.services.jcr.ext.replication.storage.Member;
import org.exoplatform.services.jcr.ext.replication.storage.RandomChangesFile;

public class IncomeDataContext {
    private final RandomChangesFile changesFile;
    private final Member member;
    private final long totalPackets;
    private long savedPackets;

    public IncomeDataContext(RandomChangesFile changesFile, Member member, long totalPackets) {
        this.changesFile = changesFile;
        this.member = member;
        this.totalPackets = totalPackets;
        this.savedPackets = 0L;
    }

    public RandomChangesFile getChangesFile() {
        return this.changesFile;
    }

    public Member getMember() {
        return this.member;
    }

    public void writeData(byte[] buf, long offset) throws IOException {
        this.changesFile.writeData(buf, offset);
        ++this.savedPackets;
        if (this.savedPackets == this.totalPackets) {
            this.changesFile.finishWrite();
        }
    }

    public boolean isFinished() {
        return this.savedPackets == this.totalPackets;
    }
}

