/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.wysiwyg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.web.resource.config.xml.FCKConfigListener;
import org.exoplatform.webui.form.wysiwyg.FCKEditorConfig;
import org.exoplatform.webui.form.wysiwyg.XHtmlTagTool;

public class FCKEditor {
    private static final String DEFAULT_HEIGHT = "300".intern();
    private static final String DEFAULT_WIDTH = "100%".intern();
    private static final String DEFAULT_TOOLBAR = "Basic".intern();
    private FCKEditorConfig config;
    private String instanceName;
    private String value;
    private String basePath;
    private HttpServletRequest request;
    private String toolbarSet;
    private String width;
    private String height;

    public FCKEditor(HttpServletRequest request, String instanceName, String width, String height, String toolbarSet, String value, String basePath) {
        this.request = request;
        this.instanceName = instanceName;
        this.width = width;
        this.height = height;
        this.toolbarSet = toolbarSet;
        this.value = value;
        this.basePath = basePath;
        this.config = new FCKEditorConfig();
    }

    public FCKEditor(HttpServletRequest request, String instanceName) {
        this(request, instanceName, DEFAULT_WIDTH, DEFAULT_HEIGHT, DEFAULT_TOOLBAR, null, FCKConfigListener.FCK_CONTEXT_PATH + "/fckeditor");
    }

    public void setInstanceName(String value) {
        this.instanceName = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setBasePath(String value) {
        this.basePath = value;
    }

    public void setToolbarSet(String value) {
        this.toolbarSet = value;
    }

    public void setWidth(String value) {
        this.width = value;
    }

    public void setHeight(String value) {
        this.height = value;
    }

    public FCKEditorConfig getConfig() {
        return this.config;
    }

    public void setConfig(FCKEditorConfig value) {
        this.config = value;
    }

    private String escapeXml(String txt) {
        txt = txt.replaceAll("&", "&#38;");
        txt = txt.replaceAll("<", "&#60;");
        txt = txt.replaceAll(">", "&#62;");
        txt = txt.replaceAll("\"", "&#34;");
        txt = txt.replaceAll("'", "&#39;");
        return txt;
    }

    public String create() {
        return this.createHtml();
    }

    public String toString() {
        return this.createHtml();
    }

    public String createHtml() {
        StringBuffer strEditor = new StringBuffer();
        strEditor.append("<div>");
        String encodedValue = this.escapeXml(this.value.replaceAll("((\r?\n)+|\t*)", ""));
        if (this.check(this.request.getHeader("user-agent"))) {
            strEditor.append(this.createInputForVariable(this.instanceName, this.instanceName, encodedValue));
            String configStr = this.config.getUrlParams();
            if (configStr != null && configStr.length() > 0) {
                configStr = configStr.substring(1);
                strEditor.append(this.createInputForVariable(null, this.instanceName.concat("___Config"), configStr));
            }
            String sLink = this.basePath.concat("/editor/fckeditor.html?InstanceName=").concat(this.instanceName);
            if (this.toolbarSet != null && this.toolbarSet.length() > 0) {
                sLink = sLink + "&Toolbar=".concat(this.toolbarSet);
            }
            XHtmlTagTool iframeTag = new XHtmlTagTool("iframe", " ");
            iframeTag.addAttribute("id", this.instanceName.concat("___Frame"));
            iframeTag.addAttribute("src", sLink);
            iframeTag.addAttribute("width", this.width);
            iframeTag.addAttribute("height", this.height);
            iframeTag.addAttribute("frameborder", "no");
            iframeTag.addAttribute("scrolling", "no");
            strEditor.append(iframeTag);
        } else {
            XHtmlTagTool textareaTag = new XHtmlTagTool("textarea", encodedValue);
            textareaTag.addAttribute("name", this.instanceName);
            textareaTag.addAttribute("rows", "4");
            textareaTag.addAttribute("cols", "40");
            textareaTag.addAttribute("wrap", "virtual");
            textareaTag.addAttribute("style", "width: ".concat(this.width).concat("; height: ").concat(this.height));
        }
        strEditor.append("</div>");
        return strEditor.toString();
    }

    private String createInputForVariable(String name, String id, String value) {
        XHtmlTagTool tag = new XHtmlTagTool("input");
        tag.addAttribute("id", id);
        tag.addAttribute("name", name);
        tag.addAttribute("value", value);
        tag.addAttribute("type", "hidden");
        return tag.toString();
    }

    public boolean check(String userAgentString) {
        float version;
        if (userAgentString.indexOf("Opera") < 0 && userAgentString.indexOf("mac") < 0 && (version = this.getBrowserVersion(userAgentString, ".*MSIE ([\\d]+.[\\d]+).*")) != -1.0f && version >= 5.5f) {
            return true;
        }
        version = this.getBrowserVersion(userAgentString, ".*Gecko/([\\d]+).*");
        if (version != -1.0f && version >= 2.003021E7f) {
            return true;
        }
        version = this.getBrowserVersion(userAgentString, "Opera/([\\d]+.[\\d]+).*");
        if (version != -1.0f && version >= 9.5f) {
            return true;
        }
        version = this.getBrowserVersion(userAgentString, ".*Opera ([\\d]+.[\\d]+)");
        if (version != -1.0f && version >= 9.5f) {
            return true;
        }
        version = this.getBrowserVersion(userAgentString, ".*AppleWebKit/([\\d]+).*");
        return version != -1.0f && version >= 522.0f;
    }

    private float getBrowserVersion(String userAgent, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.matches()) {
            try {
                return Float.parseFloat(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1.0f;
            }
        }
        return -1.0f;
    }
}

