/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileHandlerImpl;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JCROrganizationServiceImpl
extends BaseOrganizationService
implements Startable {
    public static final String REPOSITORY_NAME = "repository";
    public static final String STORAGE_PATH = "storage-path";
    public static final String STORAGE_WORKSPACE = "storage-workspace";
    public static final String STORAGE_PATH_DEFAULT = "/exo:organization";
    private static final String SERVICE_NAME = "JCROrganization";
    protected RepositoryService repositoryService;
    protected RegistryService registryService;
    protected String storagePath;
    protected String repositoryName;
    protected String storageWorkspace;
    protected InitParams initParams;
    private static Log log = ExoLogger.getLogger((String)"jcr.JCROrganizationService");

    public JCROrganizationServiceImpl(InitParams params, RepositoryService repositoryService) throws ConfigurationException {
        this(params, repositoryService, null);
    }

    public JCROrganizationServiceImpl(InitParams initParams, RepositoryService repositoryService, RegistryService registryService) throws ConfigurationException {
        this.repositoryService = repositoryService;
        this.registryService = registryService;
        if (initParams == null) {
            throw new ConfigurationException("Init parameters expected !!!");
        }
        this.initParams = initParams;
        this.userDAO_ = new UserHandlerImpl(this);
        this.userProfileDAO_ = new UserProfileHandlerImpl(this);
        this.groupDAO_ = new GroupHandlerImpl(this);
        this.membershipDAO_ = new MembershipHandlerImpl(this);
        this.membershipTypeDAO_ = new MembershipTypeHandlerImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting JCROrganizationService");
        }
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    log.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
        this.checkParams();
        try {
            Session session = this.getStorageSession();
            try {
                session.getItem(this.storagePath);
            }
            catch (PathNotFoundException e) {
                Node storage = session.getRootNode().addNode(this.storagePath.substring(1), "exo:organizationStorage");
                storage.addNode("exo:users", "exo:organizationUsers");
                storage.addNode("exo:groups", "exo:organizationGroups");
                storage.addNode("exo:membershipTypes", "exo:organizationMembershipTypes");
                session.save();
            }
            finally {
                session.logout();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not configure storage", e);
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    String getStoragePath() throws RepositoryException {
        if (this.storagePath == null) {
            throw new RepositoryException("Can not get storage path because JCROrganizationService is not started");
        }
        return this.storagePath;
    }

    Session getStorageSession() throws RepositoryException {
        try {
            ManageableRepository repository = this.getWorkingRepository();
            String workspaceName = this.storageWorkspace;
            if (workspaceName == null) {
                workspaceName = repository.getConfiguration().getDefaultWorkspaceName();
            }
            return repository.getSystemSession(workspaceName);
        }
        catch (NullPointerException e) {
            throw new RepositoryException("Can not get system session because JCROrganizationService is not started", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException("Can not get system session", (Throwable)e);
        }
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        String entryPath = "exo:services/JCROrganization/repository";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.repositoryName = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/JCROrganization/storage-path";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.storagePath = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/JCROrganization/storage-workspace";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.storageWorkspace = this.getAttributeSmart(element, "value");
        if (this.repositoryName != null) {
            log.info((Object)("Repository from RegistryService: " + this.repositoryName));
        }
        if (this.storageWorkspace != null) {
            log.info((Object)("Workspace from RegistryService: " + this.storageWorkspace));
        }
        if (this.storagePath != null) {
            log.info((Object)("Root node from RegistryService: " + this.storagePath));
        }
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement(REPOSITORY_NAME);
        this.setAttributeSmart(element, "value", this.repositoryName);
        root.appendChild(element);
        element = doc.createElement(STORAGE_PATH);
        this.setAttributeSmart(element, "value", this.storagePath);
        root.appendChild(element);
        element = doc.createElement(STORAGE_WORKSPACE);
        this.setAttributeSmart(element, "value", this.storageWorkspace);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private void readParamsFromFile() {
        ValueParam paramRepository = this.initParams.getValueParam(REPOSITORY_NAME);
        this.repositoryName = paramRepository != null ? paramRepository.getValue() : null;
        ValueParam paramStoragePath = this.initParams.getValueParam(STORAGE_PATH);
        this.storagePath = paramStoragePath != null ? paramStoragePath.getValue() : null;
        ValueParam paramStorageWorkspace = this.initParams.getValueParam(STORAGE_WORKSPACE);
        String string = this.storageWorkspace = paramStorageWorkspace != null ? paramStorageWorkspace.getValue() : null;
        if (this.repositoryName != null) {
            log.info((Object)("Repository from configuration file: " + this.repositoryName));
        }
        if (this.storageWorkspace != null) {
            log.info((Object)("Workspace from configuration file: " + this.storageWorkspace));
        }
        if (this.storagePath != null) {
            log.info((Object)("Root node from configuration file: " + this.storagePath));
        }
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void checkParams() {
        if (this.storagePath != null) {
            if (this.storagePath.equals("/")) {
                throw new RuntimeException("Storage path can not be a root node");
            }
        } else {
            this.storagePath = STORAGE_PATH_DEFAULT;
        }
    }

    private ManageableRepository getWorkingRepository() throws RepositoryException, RepositoryConfigurationException {
        return this.repositoryName != null ? this.repositoryService.getRepository(this.repositoryName) : this.repositoryService.getCurrentRepository();
    }
}

