/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.msg.MessageService;

public class DbMessageService
implements MessageService {
    private static final long serialVersionUID = 1L;
    final JobSession jobSession;
    final JobExecutor jobExecutor;
    boolean hasProducedJobs;
    private static Log log = LogFactory.getLog((Class)DbMessageService.class);

    public DbMessageService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
        this.jobSession = jbpmContext.getJobSession();
        this.jobExecutor = jbpmContext.getJbpmConfiguration().getJobExecutor();
    }

    public void send(Job job) {
        this.jobSession.saveJob(job);
        this.hasProducedJobs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.hasProducedJobs && this.jobExecutor != null) {
            log.debug((Object)"messages were produced, job executor will be notified");
            JobExecutor jobExecutor = this.jobExecutor;
            synchronized (jobExecutor) {
                this.jobExecutor.notify();
            }
        }
    }
}

