/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BeanHandler;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.xml.sax.Attributes;

public class GroupBeanHandler
extends BeanHandler {
    public GroupBeanHandler(String name, BeanAdapterFactory beanAdapterFactory) {
        super(name, beanAdapterFactory);
    }

    public Object startParticle(Object parent, QName qName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (!(parent instanceof BeanAdapter)) {
            throw new JBossXBRuntimeException("Parent expected to be an instance of BeanAdapter: " + parent);
        }
        TermBinding term = particle.getTerm();
        if (!term.isModelGroup()) {
            throw new JBossXBRuntimeException("The term expected to be a model group: " + term);
        }
        ModelGroupBinding group = (ModelGroupBinding)term;
        QName groupName = group.getQName();
        if (groupName == null) {
            throw new JBossXBRuntimeException("The group has to have a non-null QName. Failed to start element " + qName);
        }
        AbstractPropertyHandler groupHandler = ((BeanAdapter)parent).getPropertyHandler(groupName);
        if (groupHandler == null) {
            throw new JBossXBRuntimeException("No property mapped for group " + qName + " in bean adapter" + ((BeanAdapter)parent).getValue() + ", available: " + ((BeanAdapter)parent).getAvailable());
        }
        Object groupValue = null;
        PropertyInfo propertyInfo = groupHandler.getPropertyInfo();
        if (propertyInfo.isReadable()) {
            Object parentValue = ((BeanAdapter)parent).getValue();
            try {
                groupValue = ((BeanAdapter)parent).get(propertyInfo);
            }
            catch (Throwable e) {
                throw new JBossXBRuntimeException("Failed to get group value from parent: parent=" + parentValue + ", property=" + propertyInfo.getName() + ", qName=" + qName, e);
            }
        }
        if (groupValue == null) {
            return super.startParticle(parent, qName, particle, attrs, nsCtx);
        }
        return new SingletonBeanAdapter(this.getBeanAdapterFactory(), groupValue);
    }

    private static class SingletonBeanAdapter
    extends BeanAdapter {
        private final Object value;

        public SingletonBeanAdapter(BeanAdapterFactory beanAdapterFactory, Object instance) {
            super(beanAdapterFactory);
            this.value = instance;
        }

        protected Object construct() {
            return this.value;
        }

        public Object get(PropertyInfo propertyInfo) throws Throwable {
            return propertyInfo.get(this.value);
        }

        public Object getValue() {
            return this.value;
        }

        public void set(PropertyInfo propertyInfo, Object child) throws Throwable {
            propertyInfo.set(this.value, child);
        }
    }
}

