/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.form.validator.IllegalDMSCharValidator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFolderForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TYPE = "type";
    private String allowCreateFolder_;

    public void activate() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        String foldertypes = uiExplorer.getDriveData().getAllowCreateFolders();
        if (foldertypes.contains(",")) {
            this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, null));
            String[] arrFoldertypes = foldertypes.split(",");
            String label = "";
            for (String foldertype : arrFoldertypes) {
                try {
                    label = res.getString(this.getId() + ".label." + foldertype.replace(":", "_"));
                }
                catch (MissingResourceException e) {
                    label = foldertype;
                }
                options.add(new SelectItemOption(label, (Object)foldertype));
            }
            Collections.sort(options, new ItemOptionNameComparator());
            this.getUIFormSelectBox(FIELD_TYPE).setOptions(options);
        } else {
            this.allowCreateFolder_ = foldertypes;
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IllegalDMSCharValidator.class, new Object[0]));
        this.setActions(new String[]{"Save", "Cancel"});
        this.getUIStringInput(FIELD_NAME).setValue(null);
        if (this.getUIFormSelectBox(FIELD_TYPE) != null && uiExplorer.getCurrentNode().isNodeType("nt:folder") && ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode().isNodeType("nt:folder")) {
            options.clear();
            options.add(new SelectItemOption(res.getString(this.getId() + ".label." + "nt:folder".replace(":", "_")), (Object)"nt:folder"));
            Collections.sort(options, new ItemOptionNameComparator());
            this.getUIFormSelectBox(FIELD_TYPE).setOptions(options);
        }
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIFolderForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIFolderForm uiFolderForm = (UIFolderForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiFolderForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiFolderForm.getAncestorOfType(UIApplication.class);
            String name = (String)uiFolderForm.getUIStringInput(UIFolderForm.FIELD_NAME).getValue();
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (name == null || name.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.name-invalid", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String type = null;
            type = uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_TYPE) != null ? (String)uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_TYPE).getValue() : uiFolderForm.allowCreateFolder_;
            try {
                node.addNode(Text.escapeIllegalJcrChars((String)name), type);
                node.save();
                node.getSession().save();
                if (!uiExplorer.getPreference().isJcrEnable()) {
                    node.getSession().save();
                }
                uiExplorer.updateAjax(event);
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{type};
                throw new MessageException(new ApplicationMessage("UIFolderForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.repository-exception-permission", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException re) {
                NodeDefinition[] definitions;
                String key = "";
                for (NodeDefinition def : definitions = node.getPrimaryNodeType().getChildNodeDefinitions()) {
                    key = node.hasNode(name) || !def.allowsSameNameSiblings() ? "UIFolderForm.msg.not-allow-sameNameSibling" : "UIFolderForm.msg.repository-exception";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NumberFormatException nume) {
                String key = "UIFolderForm.msg.numberformat-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
    }
}

