/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.extensions.component.rest;

import java.util.List;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/authoring/")
public class LifecycleConnector
implements ResourceContainer {
    @GET
    @Path(value="/bystate/")
    public Response byState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/tostate/")
    public Response toState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="tostate") String tostate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, tostate, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/bydate/")
    public Response byDate(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="date") String date, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, date, null, lang, workspace, json);
    }

    private Response getContents(String fromstate, String tostate, String date, String user, String lang, String workspace, String asJSon) throws Exception {
        try {
            StringBuffer json = new StringBuffer();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("contents");
            document.appendChild(root);
            PublicationManager manager = (PublicationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationManager.class);
            List<Node> nodes = manager.getContents(fromstate, tostate, date, user, lang, workspace);
            json.append("[");
            boolean first = true;
            for (Node node : nodes) {
                String pubDate;
                String name = node.getName();
                String path = node.getPath();
                String title = null;
                if (node.hasProperty("exo:title")) {
                    title = node.getProperty("exo:title").getString();
                }
                String string = pubDate = node.hasProperty("publication:startPublishedDate") ? node.getProperty("publication:startPublishedDate").getString() : null;
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("{");
                json.append("\"name\":\"" + name + "\"");
                if (title != null) {
                    json.append(",\"title\":\"" + title + "\"");
                }
                json.append(",\"path\":\"" + path + "\"");
                Element element = document.createElement("content");
                element.setAttribute("name", name);
                if (title != null) {
                    element.setAttribute("title", title);
                }
                element.setAttribute("path", path);
                if (pubDate != null) {
                    json.append(",\"publishedDate\":\"" + pubDate + "\"");
                    element.setAttribute("publishedDate", pubDate);
                }
                root.appendChild(element);
                json.append("}");
            }
            json.append("]");
            if ("true".equals(asJSon)) {
                return Response.ok((Object)json.toString(), (String)"text/plain").build();
            }
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().build();
        }
    }
}

