/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class IssuingDistributionPoint
extends ASN1Encodable {
    private DistributionPointName distributionPoint;
    private boolean onlyContainsUserCerts;
    private boolean onlyContainsCACerts;
    private ReasonFlags onlySomeReasons;
    private boolean indirectCRL;
    private boolean onlyContainsAttributeCerts;
    private ASN1Sequence seq;

    public static IssuingDistributionPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return IssuingDistributionPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static IssuingDistributionPoint getInstance(Object object) {
        if (object == null || object instanceof IssuingDistributionPoint) {
            return (IssuingDistributionPoint)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IssuingDistributionPoint((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public IssuingDistributionPoint(DistributionPointName distributionPointName, boolean bl, boolean bl2, ReasonFlags reasonFlags, boolean bl3, boolean bl4) {
        this.distributionPoint = distributionPointName;
        this.indirectCRL = bl3;
        this.onlyContainsAttributeCerts = bl4;
        this.onlyContainsCACerts = bl2;
        this.onlyContainsUserCerts = bl;
        this.onlySomeReasons = reasonFlags;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (distributionPointName != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, distributionPointName));
        }
        if (!bl) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, new DERBoolean(true)));
        }
        if (!bl2) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, new DERBoolean(true)));
        }
        if (reasonFlags != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, reasonFlags));
        }
        if (!bl3) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 4, new DERBoolean(true)));
        }
        if (!bl4) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 5, new DERBoolean(true)));
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public IssuingDistributionPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        block8: for (int i = 0; i != aSN1Sequence.size(); ++i) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.distributionPoint = DistributionPointName.getInstance(aSN1TaggedObject, true);
                    continue block8;
                }
                case 1: {
                    this.onlyContainsUserCerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 2: {
                    this.onlyContainsCACerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 3: {
                    this.onlySomeReasons = new ReasonFlags(ReasonFlags.getInstance(aSN1TaggedObject, false));
                    continue block8;
                }
                case 4: {
                    this.indirectCRL = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 5: {
                    this.onlyContainsAttributeCerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in IssuingDistributionPoint");
                }
            }
        }
    }

    public boolean onlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean onlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public boolean isIndirectCRL() {
        return this.indirectCRL;
    }

    public boolean onlyContainsAttributeCerts() {
        return this.onlyContainsAttributeCerts;
    }

    public DistributionPointName getDistributionPoint() {
        return this.distributionPoint;
    }

    public ReasonFlags getOnlySomeReasons() {
        return this.onlySomeReasons;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

