/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.MethodInvokerFactory;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDispatcher {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.RequestDispatcher");
    protected final ResourceBinder resourceBinder;
    private final MethodInvokerFactory invokerFactory;

    public RequestDispatcher(ResourceBinder resourceBinder, MethodInvokerFactory invokerFactory) {
        this.resourceBinder = resourceBinder;
        this.invokerFactory = invokerFactory;
    }

    public RequestDispatcher(ResourceBinder resourceBinder) {
        this(resourceBinder, null);
    }

    public void dispatch(GenericContainerRequest request, GenericContainerResponse response) {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        String requestPath = context.getPath(false);
        List<String> parameterValues = context.getParameterValues();
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.getRootResourse(parameterValues, requestPath);
        String newRequestPath = RequestDispatcher.getPathTail(parameterValues);
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(resourceFactory.getObjectModel().getUriPattern().getParameterNames());
        Object resource = resourceFactory.getInstance(context);
        this.dispatch(request, response, context, resourceFactory, resource, newRequestPath);
    }

    private static String getPathTail(List<String> parameterValues) {
        int i = parameterValues.size() - 1;
        return parameterValues.get(i) != null ? parameterValues.get(i) : "";
    }

    private void dispatch(GenericContainerRequest request, GenericContainerResponse response, ApplicationContext context, ObjectFactory<AbstractResourceDescriptor> resourceFactory, Object resource, String requestPath) {
        List<String> parameterValues = context.getParameterValues();
        int len = parameterValues.size();
        ResourceMethodMap<ResourceMethodDescriptor> rmm = resourceFactory.getObjectModel().getResourceMethods();
        SubResourceMethodMap srmm = resourceFactory.getObjectModel().getSubResourceMethods();
        SubResourceLocatorMap srlm = resourceFactory.getObjectModel().getSubResourceLocators();
        if ((parameterValues.get(len - 1) == null || "/".equals(parameterValues.get(len - 1))) && rmm.size() > 0) {
            ArrayList methods = new ArrayList();
            boolean match = RequestDispatcher.processResourceMethod(rmm, request, response, methods);
            if (!match) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not found resource method for method " + request.getMethod()));
                }
                return;
            }
            this.invokeResourceMethod((ResourceMethodDescriptor)methods.get(0), resource, context, request, response);
        } else {
            ArrayList<SubResourceMethodDescriptor> methods = new ArrayList<SubResourceMethodDescriptor>();
            boolean match = RequestDispatcher.processSubResourceMethod(srmm, requestPath, request, response, parameterValues, methods);
            ArrayList<SubResourceLocatorDescriptor> locators = new ArrayList<SubResourceLocatorDescriptor>();
            boolean hasAcceptableLocator = RequestDispatcher.processSubResourceLocator(srlm, requestPath, parameterValues, locators);
            if (!match && !hasAcceptableLocator) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not found sub-resource methods nor sub-resource locators for path " + requestPath + " and method " + request.getMethod()));
                }
                return;
            }
            if (!hasAcceptableLocator && match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) < 0) {
                this.invokeSubResourceMethod(requestPath, (SubResourceMethodDescriptor)methods.get(0), resource, context, request, response);
            } else if (hasAcceptableLocator && !match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) > 0) {
                this.invokeSuResourceLocator(requestPath, (SubResourceLocatorDescriptor)locators.get(0), resource, context, request, response);
            }
        }
    }

    private void invokeResourceMethod(ResourceMethodDescriptor rmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        Class<?> returnType = rmd.getResponseType();
        MethodInvoker invoker = rmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, rmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, rmd.produces());
    }

    private void invokeSubResourceMethod(String requestPath, SubResourceMethodDescriptor srmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        context.addMatchedURI(requestPath);
        context.setParameterNames(srmd.getUriPattern().getParameterNames());
        Class<?> returnType = srmd.getResponseType();
        MethodInvoker invoker = srmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, srmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, srmd.produces());
    }

    private void invokeSuResourceLocator(String requestPath, SubResourceLocatorDescriptor srld, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        String newRequestPath = RequestDispatcher.getPathTail(context.getParameterValues());
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(srld.getUriPattern().getParameterNames());
        MethodInvoker invoker = srld.getMethodInvoker();
        resource = invoker.invokeMethod(resource, srld, context);
        AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resource, this.invokerFactory);
        SingletonObjectFactory<AbstractResourceDescriptor> locResource = new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource);
        this.dispatch(request, response, context, locResource, resource, newRequestPath);
    }

    private int compareSubResources(SubResourceMethodDescriptor srmd, SubResourceLocatorDescriptor srld) {
        int r = UriPattern.URIPATTERN_COMPARATOR.compare(srmd.getUriPattern(), srld.getUriPattern());
        if (r == 0) {
            return -1;
        }
        return r;
    }

    private static void processResponse(Object o, Class<?> returnType, GenericContainerRequest request, GenericContainerResponse response, List<MediaType> produces) {
        MediaType contentType = request.getAcceptableMediaType(produces);
        if (returnType == Void.TYPE || o == null) {
            response.setResponse(Response.noContent().build());
        } else if (Response.class.isAssignableFrom(returnType)) {
            Response r = (Response)o;
            if (r.getMetadata().getFirst((Object)"Content-Type") == null && r.getEntity() != null) {
                r.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
            }
            response.setResponse(r);
        } else if (GenericEntity.class.isAssignableFrom(returnType)) {
            response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
        } else {
            response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
        }
    }

    private static <T extends ResourceMethodDescriptor> boolean processResourceMethod(ResourceMethodMap<T> rmm, GenericContainerRequest request, GenericContainerResponse response, List<T> methods) {
        List<T> rmds = rmm.getList(request.getMethod());
        if (rmds == null || rmds.size() == 0) {
            response.setResponse(Response.status((int)405).header("Allow", (Object)HeaderHelper.convertToString(rmm.getAllow())).build());
            return false;
        }
        MediaType contentType = request.getMediaType();
        if (contentType == null) {
            methods.addAll(rmds);
        } else {
            for (ResourceMethodDescriptor rmd : rmds) {
                if (!MediaTypeHelper.isConsume(rmd.consumes(), contentType)) continue;
                methods.add(rmd);
            }
        }
        if (methods.isEmpty()) {
            response.setResponse(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
            return false;
        }
        List acceptable = request.getAcceptableMediaTypes();
        float previousQValue = 0.0f;
        int n = 0;
        int p = 0;
        ListIterator<T> i = methods.listIterator();
        while (i.hasNext()) {
            n = i.nextIndex();
            ResourceMethodDescriptor rmd = (ResourceMethodDescriptor)i.next();
            float qValue = MediaTypeHelper.processQuality(acceptable, rmd.produces());
            if (qValue > previousQValue) {
                previousQValue = qValue;
                p = n;
                continue;
            }
            i.remove();
        }
        if (!methods.isEmpty()) {
            if (methods.size() > 1) {
                n = 0;
                i = methods.listIterator();
                while (i.hasNext()) {
                    i.next();
                    if (n == p) break;
                    i.remove();
                    ++n;
                }
            }
            return true;
        }
        response.setResponse(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
        return false;
    }

    private static boolean processSubResourceMethod(SubResourceMethodMap srmm, String requestedPath, GenericContainerRequest request, GenericContainerResponse response, List<String> capturingValues, List<SubResourceMethodDescriptor> methods) {
        ResourceMethodMap rmm = null;
        for (Map.Entry e : srmm.entrySet()) {
            int len;
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1))) continue;
            rmm = (ResourceMethodMap)e.getValue();
            break;
        }
        if (rmm == null) {
            response.setResponse(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return false;
        }
        ArrayList l = new ArrayList();
        boolean match = RequestDispatcher.processResourceMethod(rmm, request, response, l);
        if (match) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                methods.add((SubResourceMethodDescriptor)i.next());
            }
        }
        return match;
    }

    private static boolean processSubResourceLocator(SubResourceLocatorMap srlm, String requestedPath, List<String> capturingValues, List<SubResourceLocatorDescriptor> locators) {
        for (Map.Entry e : srlm.entrySet()) {
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues)) continue;
            locators.add((SubResourceLocatorDescriptor)e.getValue());
        }
        return !locators.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectFactory<AbstractResourceDescriptor> getRootResourse(List<String> parameterValues, String requestPath) {
        List<ObjectFactory<AbstractResourceDescriptor>> resources;
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = null;
        List<ObjectFactory<AbstractResourceDescriptor>> list = resources = this.resourceBinder.getResources();
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> rc : resources) {
                int subresnum;
                int len;
                if (!rc.getObjectModel().getUriPattern().match(requestPath, parameterValues) || parameterValues.get((len = parameterValues.size()) - 1) != null && !parameterValues.get(len - 1).equals("/") && (subresnum = rc.getObjectModel().getSubResourceMethods().size() + rc.getObjectModel().getSubResourceLocators().size()) == 0) continue;
                resourceFactory = rc;
                break;
            }
        }
        if (resourceFactory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Root resource not found for " + requestPath));
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        return resourceFactory;
    }
}

