/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/nodetype/UINodeTypeList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UINodeTypeList.msg.confirm-delete"), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ExportActionListener.class})})
public class UINodeTypeList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UINodeTypeListIterator");
    public static final String DRAFTNODETYPE = "jcr:system/jcr:nodetypesDraft";
    public static final String[] ACTIONS = new String[]{"Add", "Import", "Export"};
    public static final String[] CANCEL = new String[]{"Cancel"};
    public static final String[] TAB_REMOVE = new String[]{"SuperTypeTab", "DefaultTypeTab", "RequiredTypeTab"};

    public UINodeTypeList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public List getAllNodeTypes() throws Exception {
        ArrayList<Object> nodeList = new ArrayList<Object>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ManageableRepository mRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        ExtendedNodeTypeManager ntManager = mRepository.getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        while (nodeTypeIter.hasNext()) {
            nodeList.add(nodeTypeIter.nextNodeType());
        }
        Collections.sort(nodeList, new Utils.NodeTypeNameComparator());
        Session session = mRepository.getSystemSession(mRepository.getConfiguration().getSystemWorkspaceName());
        if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
            Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
            NodeIterator nodeIter = draftNode.getNodes();
            while (nodeIter.hasNext()) {
                nodeList.add(nodeIter.nextNode());
            }
        }
        session.logout();
        return nodeList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getNodeTypeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(String name, int currentPage, List<NodeType> nodeType) throws Exception {
        ObjectPageList pageList = new ObjectPageList(nodeType, 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public void refresh(String name, int currentPage) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ManageableRepository manaRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
        if (name != null) {
            if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
                Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
                if (draftNode.hasNode(name)) {
                    Node deleteNode = draftNode.getNode(name);
                    deleteNode.remove();
                    draftNode.save();
                }
                if (!draftNode.hasNodes()) {
                    draftNode.remove();
                }
                session.save();
            }
        } else {
            session.refresh(true);
        }
        session.logout();
        this.refresh(name, currentPage, this.getAllNodeTypes());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiNodeList = (UINodeTypeList)((Object)event.getSource());
            String repository = ((UIECMAdminPortlet)uiNodeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            ManageableRepository manaRepository = ((RepositoryService)uiNodeList.getApplicationComponent(RepositoryService.class)).getRepository(repository);
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            if (session.getRootNode().hasNode(UINodeTypeList.DRAFTNODETYPE)) {
                Node draftNode = session.getRootNode().getNode(UINodeTypeList.DRAFTNODETYPE);
                Node deleteNode = draftNode.getNode(nodeName);
                deleteNode.remove();
                draftNode.save();
                if (!draftNode.hasNodes()) {
                    draftNode.remove();
                }
                session.save();
                uiNodeList.refresh(null, uiNodeList.getUIPageIterator().getCurrentPage());
                event.getRequestContext().addUIComponentToUpdateByAjax(uiNodeList.getParent());
            }
            session.logout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiNodeList = (UINodeTypeList)((Object)event.getSource());
            String repository = ((UIECMAdminPortlet)uiNodeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            ManageableRepository manaRepository = ((RepositoryService)uiNodeList.getApplicationComponent(RepositoryService.class)).getRepository(repository);
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            Node draftNodeType = session.getRootNode().getNode("jcr:system/jcr:nodetypesDraft/" + nodeName);
            UINodeTypeManager uiManager = (UINodeTypeManager)uiNodeList.getParent();
            uiManager.initPopup(false);
            UINodeTypeForm uiForm = (UINodeTypeForm)uiManager.findFirstComponentOfType(UINodeTypeForm.class);
            uiForm.refresh();
            uiForm.removeChildTabs(TAB_REMOVE);
            uiForm.updateEdit(draftNodeType, true);
            UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiForm.getChildById("nodeTypeDefinition");
            String[] actionNames = new String[]{"Save", "SaveDraft", "Cancel"};
            tab.setActions(actionNames, null);
            tab.setIsView(false);
            uiForm.setTabRender("nodeTypeDefinition");
            session.logout();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            String ntName = event.getRequestContext().getRequestParameter("objectId");
            String repository = ((UIECMAdminPortlet)uiList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            ManageableRepository manaRepository = ((RepositoryService)uiList.getApplicationComponent(RepositoryService.class)).getRepository(repository);
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nodeType = ntManager.getNodeType(ntName);
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.initPopup(true);
            UINodeTypeForm uiForm = (UINodeTypeForm)uiManager.findFirstComponentOfType(UINodeTypeForm.class);
            uiForm.update(nodeType, true);
            for (UIComponent uiComp : uiForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiForm.getChildById(uiComp.getId());
                for (UIComponent uiChild : tab.getChildren()) {
                    if (uiChild instanceof UIFormInputInfo) continue;
                    tab.setActionInfo(uiChild.getName(), null);
                }
                if (tab.getId().equals("nodeTypeDefinition")) {
                    tab.setRendered(true);
                    tab.setActions(new String[]{"Close"}, null);
                    continue;
                }
                tab.setRendered(false);
                tab.setActions(null, null);
            }
            uiForm.removeChildTabs(TAB_REMOVE);
            session.logout();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExportActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.setExportPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.setImportPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.initPopup(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

