/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.ValueOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.DeleteValues;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.WriteValue;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FileIOChannel
extends ValueFileIOHelper
implements ValueIOChannel {
    private static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.FileIOChannel");
    protected final File tempDir;
    protected final File rootDir;
    protected final FileCleaner cleaner;
    protected final ValueDataResourceHolder resources;
    protected final String storageId;
    protected final List<ValueOperation> changes = new ArrayList<ValueOperation>();

    public FileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
        this.storageId = storageId;
        this.resources = resources;
        this.tempDir = new File(rootDir, "temp");
    }

    public void write(String propertyId, ValueData value) throws IOException {
        WriteValue o = new WriteValue(this.getFile(propertyId, value.getOrderNumber()), value, this.resources, this.cleaner, this.tempDir);
        o.execute();
        this.changes.add(o);
    }

    public void delete(String propertyId) throws IOException {
        DeleteValues o = new DeleteValues(this.getFiles(propertyId), this.resources, this.cleaner, this.tempDir);
        o.execute();
        this.changes.add(o);
    }

    public void prepare() throws IOException {
        for (ValueOperation vo : this.changes) {
            vo.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        try {
            for (ValueOperation vo : this.changes) {
                vo.commit();
            }
            Object var4_3 = null;
            this.changes.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.changes.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void twoPhaseCommit() throws IOException {
        try {
            for (ValueOperation vo : this.changes) {
                vo.twoPhaseCommit();
            }
            Object var4_3 = null;
            this.changes.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.changes.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        try {
            for (int p = this.changes.size() - 1; p >= 0; --p) {
                this.changes.get(p).rollback();
            }
            Object var3_2 = null;
            this.changes.clear();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.changes.clear();
            throw throwable;
        }
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        return this.readValue(this.getFile(propertyId, orderNumber), orderNumber, maxBufferSize);
    }

    protected abstract String makeFilePath(String var1, int var2);

    protected abstract File getFile(String var1, int var2) throws IOException;

    protected abstract File[] getFiles(String var1) throws IOException;

    public String getStorageId() {
        return this.storageId;
    }
}

