/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileCleaner
extends WorkerThread {
    protected static final long DEFAULT_TIMEOUT = 30000L;
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.FileCleaner");
    protected final ConcurrentLinkedQueue<File> files = new ConcurrentLinkedQueue();

    public FileCleaner() {
        this(30000L);
    }

    public FileCleaner(long timeout) {
        this(timeout, true);
    }

    public FileCleaner(boolean start) {
        this(30000L, start);
    }

    public FileCleaner(long timeout, boolean start) {
        super(timeout);
        this.setName("FileCleaner " + this.getId());
        this.setDaemon(true);
        this.setPriority(1);
        if (start) {
            this.start();
        }
        this.registerShutdownHook();
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileCleaner instantiated name= " + this.getName() + " timeout= " + timeout));
        }
    }

    public void addFile(File file) {
        if (file.exists()) {
            this.files.offer(file);
        }
    }

    public void removeFile(File file) {
        this.files.remove(file);
    }

    public void halt() {
        try {
            this.callPeriodically();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.files != null && this.files.size() > 0) {
            log.warn((Object)("There are uncleared files: " + this.files.size()));
        }
        super.halt();
    }

    protected void callPeriodically() throws Exception {
        File file = null;
        HashSet<File> notRemovedFiles = new HashSet<File>();
        while ((file = this.files.poll()) != null) {
            if (!file.exists()) continue;
            if (!file.delete()) {
                notRemovedFiles.add(file);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not delete " + (file.isDirectory() ? "directory" : "file") + ". Will try next time: " + file.getAbsolutePath()));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)((file.isDirectory() ? "Directory" : "File") + " deleted : " + file.getAbsolutePath()));
        }
        if (!notRemovedFiles.isEmpty()) {
            this.files.addAll(notRemovedFiles);
        }
    }

    private void registerShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    File file = null;
                    while ((file = FileCleaner.this.files.poll()) != null) {
                        file.delete();
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

