/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeType;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ecm.connector.fckeditor.FCKMessage;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FCKFolderHandler {
    private TemplateService templateService;
    private FCKMessage fckMessage;

    public FCKFolderHandler(ExoContainer container) {
        this.templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        this.fckMessage = new FCKMessage();
    }

    public String getFolderType(Node node) throws Exception {
        NodeType nodeType = node.getPrimaryNodeType();
        String primaryType = nodeType.getName();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        if (this.templateService.getDocumentTemplates(repository).contains(primaryType)) {
            return null;
        }
        if (FCKUtils.NT_UNSTRUCTURED.equals(primaryType) || FCKUtils.NT_FOLDER.equals(primaryType)) {
            return primaryType;
        }
        if (nodeType.isNodeType(FCKUtils.NT_UNSTRUCTURED) || nodeType.isNodeType(FCKUtils.NT_FOLDER)) {
            return primaryType;
        }
        return primaryType;
    }

    public String getFolderURL(Node folder) throws Exception {
        return FCKUtils.createWebdavURL(folder);
    }

    public Element createFolderElement(Document document, Node child, String folderType) throws Exception {
        Element folder = document.createElement("Folder");
        folder.setAttribute("name", child.getName());
        folder.setAttribute("url", this.getFolderURL(child));
        folder.setAttribute("folderType", folderType);
        return folder;
    }

    public Response createNewFolder(Node currentNode, String newFolderName, String language) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        Document document = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        if (currentNode != null) {
            if (!FCKUtils.hasAddNodePermission(currentNode)) {
                Object[] args = new Object[]{currentNode.getPath()};
                document = this.fckMessage.createMessage(103, FCKMessage.ERROR, language, args);
                return Response.ok((Object)document, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
            }
            if (currentNode.hasNode(newFolderName)) {
                Object[] args = new Object[]{currentNode.getPath(), newFolderName};
                document = this.fckMessage.createMessage(101, FCKMessage.ERROR, language, args);
                return Response.ok((Object)document, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
            }
            currentNode.addNode(newFolderName, FCKUtils.NT_FOLDER);
            currentNode.getSession().save();
            Element rootElement = FCKUtils.createRootElement("createFolder", currentNode, this.getFolderType(currentNode));
            document = rootElement.getOwnerDocument();
            Element errorElement = document.createElement("Message");
            errorElement.setAttribute("number", Integer.toString(100));
            errorElement.setAttribute("text", this.fckMessage.getMessage(100, null, language));
            errorElement.setAttribute("type", FCKMessage.ERROR);
            rootElement.appendChild(errorElement);
            return Response.ok((Object)document, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        document = this.fckMessage.createMessage(104, FCKMessage.ERROR, language, null);
        return Response.ok((Object)document, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }
}

