/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.SearchResultPageList;
import org.exoplatform.ecm.webui.component.explorer.search.UIQueryResultPageIterator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISearchResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={OpenFolderActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class})})
public class UISearchResult
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.search.UISearchResult");
    private QueryResult queryResult_;
    private long searchTime_ = 0L;
    private boolean flag_ = false;
    private UIQueryResultPageIterator uiPageIterator_;
    private List<String> currentListNodes_ = new ArrayList<String>();
    private List<Row> currentListRows_ = new ArrayList<Row>();
    private int currentAvailablePage_ = 0;
    private boolean isEndOfIterator_ = false;
    private static String iconType = "";
    private static String iconScore = "";
    private static int PAGE_SIZE = 10;
    private List<String> categoryPathList = new ArrayList<String>();
    private String constraintsCondition;
    private static final String EXO_RESTORE_LOCATION = "exo:restoreLocation";
    private boolean isTaxonomyNode = false;
    private String workspaceName = null;
    private String currentPath = null;
    protected boolean continueWithLink = false;
    protected boolean checkWithLink = false;
    protected String linkRootPath = null;
    protected String keyword = null;
    protected RowIterator resultIter = null;
    protected LinkManager linkManager = null;
    protected Session checkSymlinkSession = null;
    protected String linkWorkspace = null;
    private static final String GET_ALL_LINK = "select * from exo:symlink where jcr:path like '$0/%'";
    private static final String CHECK_LINK_MATCH_QUERY = "select * from nt:base where jcr:path like '$0/%' and ( contains(*, '$1') or lower(exo:name) like '%$2%' )";

    public List<String> getCategoryPathList() {
        return this.categoryPathList;
    }

    public void setCategoryPathList(List<String> categoryPathListItem) {
        this.categoryPathList = categoryPathListItem;
    }

    public String getConstraintsCondition() {
        return this.constraintsCondition;
    }

    public void setConstraintsCondition(String constraintsConditionItem) {
        this.constraintsCondition = constraintsConditionItem;
    }

    public UISearchResult() throws Exception {
        this.uiPageIterator_ = (UIQueryResultPageIterator)this.addChild(UIQueryResultPageIterator.class, null, null);
    }

    public void setQueryResults(QueryResult queryResult) throws Exception {
        this.queryResult_ = queryResult;
        this.resultIter = queryResult.getRows();
        this.updateGrid(true);
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public List getCurrentList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    private boolean addNode(List<String> listNodes, Node node, List<Row> listRows, Row r) throws Exception {
        List<Object> checkList = new ArrayList();
        checkList = this.flag_ ? this.currentListNodes_ : listNodes;
        if (node.getName().equals("jcr:content")) {
            if (!checkList.contains(node.getParent().getPath())) {
                listNodes.add(node.getParent().getPath());
                listRows.add(r);
                return true;
            }
        } else if (!checkList.contains(node.getPath())) {
            listNodes.add(node.getPath());
            listRows.add(r);
            return true;
        }
        return false;
    }

    public Session getSession() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getTargetSession();
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public Node getNodeByPath(String path) throws Exception {
        try {
            JCRPath nodePath = ((SessionImpl)this.getSession()).getLocationFactory().parseJCRPath(path);
            return (Node)this.getSession().getItem(nodePath.getAsString(false));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Row> getResultList() throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
        ArrayList<String> listNodes = new ArrayList<String>();
        ArrayList<Row> listRows = new ArrayList<Row>();
        if (this.resultIter == null) {
            return new ArrayList<Row>();
        }
        if (!this.resultIter.hasNext() && this.continueWithLink) {
            this.getAllLink();
        }
        Row r = null;
        int count = 0;
        Node resultNode = null;
        while (this.resultIter.hasNext()) {
            r = this.resultIter.nextRow();
            String path = r.getValue("jcr:path").getString();
            try {
                resultNode = this.getNodeByPath(path);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't get node by path " + path), (Throwable)e);
                continue;
            }
            if (resultNode == null) continue;
            if (this.categoryPathList != null && this.categoryPathList.size() > 0) {
                for (String categoryPath : this.categoryPathList) {
                    int index = categoryPath.indexOf("/");
                    ArrayList<String> pathCategoriesList = new ArrayList<String>();
                    String searchCategory = rootTreePath + "/" + categoryPath;
                    List listCategories = taxonomyService.getCategories(resultNode, categoryPath.substring(0, index));
                    for (Node category : listCategories) {
                        pathCategoriesList.add(category.getPath());
                    }
                    if (!pathCategoriesList.contains(searchCategory)) continue;
                    if (!this.checkWithLink) {
                        if (!this.addNode(listNodes, resultNode, listRows, r)) continue;
                        ++count;
                        continue;
                    }
                    if (!this.checkTargetMatch(resultNode, this.keyword) || !this.addNode(listNodes, resultNode, listRows, r)) continue;
                    ++count;
                }
            } else {
                if (!this.checkWithLink) {
                    if (this.addNode(listNodes, resultNode, listRows, r)) {
                        ++count;
                    }
                } else if (this.checkTargetMatch(resultNode, this.keyword) && this.addNode(listNodes, resultNode, listRows, r)) {
                    ++count;
                }
                if (count == 100) break;
                if (!this.resultIter.hasNext() && this.continueWithLink) {
                    this.getAllLink();
                }
            }
            if (!this.resultIter.hasNext()) {
                this.isEndOfIterator_ = true;
            }
            if (listNodes.size() >= 100 || this.isEndOfIterator_) continue;
            this.flag_ = true;
        }
        this.currentListNodes_.addAll(listNodes);
        this.currentListRows_.addAll(listRows);
        return this.currentListRows_;
    }

    public void clearAll() {
        this.flag_ = false;
        this.isEndOfIterator_ = false;
        this.currentListNodes_.clear();
        this.currentListRows_.clear();
        this.continueWithLink = false;
        this.linkRootPath = null;
        this.checkWithLink = false;
        this.resultIter = null;
    }

    public void setRootLink(String fromPath, String keyword, String workspace) {
        if (fromPath != null && fromPath.trim().length() > 0 && keyword != null && keyword.trim().length() > 0) {
            this.keyword = keyword;
            this.linkRootPath = fromPath;
            this.continueWithLink = true;
            this.linkWorkspace = workspace;
        }
    }

    private void getAllLink() throws Exception {
        String queryStatement = GET_ALL_LINK;
        if (this.checkSymlinkSession == null) {
            SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());
            RepositoryService rs = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            this.checkSymlinkSession = sessionProvider.getSession(this.linkWorkspace, rs.getCurrentRepository());
        }
        QueryManager queryManager = this.checkSymlinkSession.getWorkspace().getQueryManager();
        queryStatement = StringUtils.replace((String)queryStatement, (String)"$0", (String)this.linkRootPath);
        Query query = queryManager.createQuery(queryStatement, "sql");
        QueryResult queryResult = query.execute();
        this.resultIter = queryResult.getRows();
        this.continueWithLink = false;
        this.checkWithLink = true;
    }

    protected boolean checkTargetMatch(Node symlinkNode, String keyword) {
        String queryStatament = CHECK_LINK_MATCH_QUERY;
        Node target = null;
        if (this.linkManager == null) {
            this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        }
        try {
            QueryManager queryManager;
            Query query;
            QueryResult queryResult;
            if (!this.linkManager.isLink((Item)symlinkNode)) {
                return true;
            }
            target = this.linkManager.getTarget(symlinkNode);
            if (target == null) {
                return false;
            }
            queryStatament = StringUtils.replace((String)queryStatament, (String)"$0", (String)target.getPath());
            queryStatament = StringUtils.replace((String)queryStatament, (String)"$1", (String)keyword.replaceAll("'", "''"));
            queryStatament = StringUtils.replace((String)queryStatament, (String)"$2", (String)keyword.replaceAll("'", "''").toLowerCase());
            if (this.checkSymlinkSession == null) {
                SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());
                this.checkSymlinkSession = sessionProvider.getSession(target.getSession().getWorkspace().getName(), (ManageableRepository)target.getSession().getRepository());
            }
            return (queryResult = (query = (queryManager = this.checkSymlinkSession.getWorkspace().getQueryManager()).createQuery(queryStatament, "sql")).execute()).getNodes().getSize() > 0L;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public UIQueryResultPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    @Deprecated
    public void setTaxonomyNode(boolean isTaxonomyNode, String workspaceName, String currentPath) {
        this.isTaxonomyNode = isTaxonomyNode;
        this.workspaceName = workspaceName;
        this.currentPath = currentPath;
    }

    @Deprecated
    public boolean isTaxonomyNode() {
        return this.isTaxonomyNode;
    }

    @Deprecated
    public Node getSymlinkNode(Node targetNode) throws Exception {
        if (targetNode == null || !targetNode.isNodeType("mix:referenceable")) {
            return null;
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        Session session = SessionProviderFactory.createSessionProvider().getSession(this.workspaceName, repositoryService.getCurrentRepository());
        String queryStatement = "select * from exo:taxonomyLink where jcr:path like '" + this.currentPath + "/%' " + "and exo:uuid='" + targetNode.getUUID() + "' " + "and exo:workspace='" + targetNode.getSession().getWorkspace().getName() + "' order by exo:primaryType DESC";
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStatement, "sql");
        if (query.execute().getNodes().getSize() > 0L) {
            return query.execute().getNodes().nextNode();
        }
        return null;
    }

    public void updateGrid(boolean flagCheck) throws Exception {
        SearchResultPageList pageList = new SearchResultPageList(this.queryResult_, this.getResultList(), PAGE_SIZE, this.isEndOfIterator_);
        this.currentAvailablePage_ = this.currentListNodes_.size() / PAGE_SIZE;
        this.uiPageIterator_.setSearchResultPageList(pageList);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }

    public int getCurrentAvaiablePage() {
        return this.currentAvailablePage_;
    }

    public String StriptHTML(String s) {
        String[] targets;
        for (String target : targets = new String[]{"<div>", "</div>", "<span>", "</span>"}) {
            s = s.replace(target, "");
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDESCActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueUpArrow";
                iconScore = "";
            } else if (objectId.equals("score")) {
                iconScore = "BlueUpArrow";
                iconType = "";
            }
            Collections.sort(uiSearchResult.currentListRows_, new SearchComparator());
            SearchResultPageList pageList = new SearchResultPageList(uiSearchResult.queryResult_, uiSearchResult.currentListRows_, PAGE_SIZE, uiSearchResult.isEndOfIterator_);
            uiSearchResult.currentAvailablePage_ = uiSearchResult.currentListNodes_.size() / PAGE_SIZE;
            uiSearchResult.uiPageIterator_.setSearchResultPageList(pageList);
            uiSearchResult.uiPageIterator_.setPageList((PageList)pageList);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearchResult.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortASCActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueDownArrow";
                iconScore = "";
            } else if (objectId.equals("score")) {
                iconScore = "BlueDownArrow";
                iconType = "";
            }
            Collections.sort(uiSearchResult.currentListRows_, new SearchComparator());
            SearchResultPageList pageList = new SearchResultPageList(uiSearchResult.queryResult_, uiSearchResult.currentListRows_, PAGE_SIZE, uiSearchResult.isEndOfIterator_);
            uiSearchResult.currentAvailablePage_ = uiSearchResult.currentListNodes_.size() / PAGE_SIZE;
            uiSearchResult.uiPageIterator_.setSearchResultPageList(pageList);
            uiSearchResult.uiPageIterator_.setPageList((PageList)pageList);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearchResult.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFolderActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSearchResult.getAncestorOfType(UIJCRExplorer.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            String folderPath = LinkUtils.getParentPath((String)path);
            Node node = null;
            try {
                node = uiExplorer.getNodeByPath(folderPath, uiExplorer.getTargetSession());
            }
            catch (AccessDeniedException ace) {
                UIApplication uiApp = (UIApplication)uiSearchResult.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot access the node at " + folderPath), (Throwable)e);
            }
            uiExplorer.setSelectNode(node.getSession().getWorkspace().getName(), folderPath);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UISearchResult> {
        public void execute(Event<UISearchResult> event) throws Exception {
            UISearchResult uiSearchResult = (UISearchResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSearchResult.getAncestorOfType(UIJCRExplorer.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiSearchResult.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiSearchResult.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (this.isInTrash(item)) {
                return;
            }
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            }
            uiExplorer.setSelectNode(workspaceName, path);
            uiExplorer.updateAjax(event);
        }

        private boolean isInTrash(Item item) throws RepositoryException {
            return item instanceof Node && ((Node)item).isNodeType(UISearchResult.EXO_RESTORE_LOCATION);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchComparator
    implements Comparator<Row> {
        private SearchComparator() {
        }

        @Override
        public int compare(Row row1, Row row2) {
            try {
                if (iconType.equals("BlueUpArrow") || iconType.equals("BlueDownArrow")) {
                    String s1 = row1.getValue("jcr:primaryType").getString();
                    String s2 = row2.getValue("jcr:primaryType").getString();
                    if (iconType.trim().equals("BlueUpArrow")) {
                        return s2.compareTo(s1);
                    }
                    return s1.compareTo(s2);
                }
                if (iconScore.equals("BlueUpArrow") || iconScore.equals("BlueDownArrow")) {
                    Long l1 = row1.getValue("jcr:score").getLong();
                    Long l2 = row2.getValue("jcr:score").getLong();
                    if (iconScore.trim().equals("BlueUpArrow")) {
                        return l2.compareTo(l1);
                    }
                    return l1.compareTo(l2);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot compare rows", (Throwable)e);
            }
            return 0;
        }
    }
}

