/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.webui;

import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.StaticAndDirectPublicationPlugin;
import org.exoplatform.services.ecm.publication.plugins.webui.VersionNode;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/workflow/webui/UIVersionTreeList.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public abstract class UIVersionTreeList
extends UIContainer {
    protected VersionNode rootVersion_;
    protected VersionNode curentVersion_;
    protected Node node_;
    protected boolean isSelectedBaseVersion_ = true;

    public VersionNode getRootVersionNode() throws Exception {
        return this.rootVersion_;
    }

    public VersionNode getCurrentVersionNode() {
        return this.curentVersion_;
    }

    public Node getCurrentNode() {
        return this.node_;
    }

    public void initVersion(Node currentNode) throws Exception {
        this.node_ = currentNode;
        this.rootVersion_ = new VersionNode(this.node_.getVersionHistory().getRootVersion());
        this.curentVersion_ = new VersionNode(this.node_.getBaseVersion());
    }

    public boolean isBaseVersion(VersionNode versionNode) throws Exception {
        return this.node_.getBaseVersion().getName().equals(versionNode.getVersion().getName());
    }

    public boolean isSelectedVersion(VersionNode versionNode) throws Exception {
        if (this.curentVersion_.equals(versionNode)) {
            return true;
        }
        return this.isBaseVersion(versionNode) && this.isSelectedBaseVersion_;
    }

    public boolean isPublised(VersionNode versionNode) throws Exception {
        Value[] publicationStates;
        for (Value value : publicationStates = this.node_.getProperty(StaticAndDirectPublicationPlugin.VERSIONS_PUBLICATION_STATES).getValues()) {
            String[] arrPublicationState = value.getString().split(",");
            for (int i = 0; i < arrPublicationState.length; ++i) {
                if (!arrPublicationState[0].equals(versionNode.getVersion().getUUID()) || !arrPublicationState[1].equals(StaticAndDirectPublicationPlugin.PUBLISHED)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void selectVersion(String var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIVersionTreeList> {
        public void execute(Event<UIVersionTreeList> event) throws Exception {
            UIVersionTreeList uiVersionTreeList = (UIVersionTreeList)((Object)event.getSource());
            String versionPath = event.getRequestContext().getRequestParameter("objectId");
            uiVersionTreeList.selectVersion(versionPath);
        }
    }
}

