/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogBufferManager;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.ReplayListener;

public class Logger
extends LogObject {
    protected volatile boolean isClosed = true;
    LogBufferManager bmgr = null;
    LogFileManager lfmgr = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public long getActiveMark() {
        return this.lfmgr.activeMark;
    }

    public Logger() throws IOException {
        this(new Configuration());
    }

    public Logger(Configuration config) throws IOException {
        super(config);
        this.lfmgr = new LogFileManager(config);
        this.bmgr = new LogBufferManager(config);
    }

    public long put(byte[][] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        return this.put((short)0, data, sync);
    }

    public long put(byte[] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        return this.put((short)0, new byte[][]{data}, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long put(short type, byte[][] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        Logger logger = this;
        synchronized (logger) {
            if (this.isClosed) {
                throw new LogClosedException();
            }
        }
        long key = this.bmgr.put(type, data, sync);
        this.lfmgr.setCurrentKey(key);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(long key, boolean force) throws InvalidLogKeyException, LogClosedException, IOException, InterruptedException {
        Logger logger = this;
        synchronized (logger) {
            if (this.isClosed) {
                throw new LogClosedException("log is closed");
            }
        }
        this.lfmgr.mark(key, force);
    }

    public void mark(long key) throws InvalidLogKeyException, LogClosedException, IOException, InterruptedException {
        this.mark(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoMark(boolean autoMark) throws InvalidLogKeyException, LogClosedException, LogFileOverflowException, IOException, InterruptedException {
        Logger logger = this;
        synchronized (logger) {
            if (this.isClosed) {
                throw new LogClosedException();
            }
        }
        this.lfmgr.setAutoMark(autoMark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        Logger logger = this;
        synchronized (logger) {
            this.isClosed = true;
        }
        this.lfmgr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InvalidFileSetException, IOException, LogConfigurationException, InvalidLogBufferException, InterruptedException {
        this.lfmgr.open();
        try {
            this.bmgr.open();
        }
        catch (ClassNotFoundException e) {
            String cnf = "LogBuffer Class not found: " + this.config.getBufferClassName();
            LogConfigurationException lce = new LogConfigurationException(cnf, e);
            throw lce;
        }
        this.lfmgr.init(this.bmgr);
        Logger logger = this;
        synchronized (logger) {
            this.isClosed = false;
        }
    }

    public void setLogEventListener(LogEventListener eventListener) {
        this.lfmgr.setLogEventListener(eventListener);
    }

    public void replay(ReplayListener listener, long mark) throws InvalidLogKeyException, LogConfigurationException {
        this.bmgr.replay(listener, mark, false);
    }

    public void replay(ReplayListener listener) throws LogConfigurationException {
        block2: {
            try {
                this.bmgr.replay(listener, this.lfmgr.activeMark, false);
            }
            catch (InvalidLogKeyException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Unhandled InvalidLogKeyException" + e.toString()));
            }
        }
    }

    protected void replay(ReplayListener listener, long mark, boolean replayCtrlRecords) throws InvalidLogKeyException, LogConfigurationException {
        this.bmgr.replay(listener, mark, replayCtrlRecords);
    }

    public LogRecord get(LogRecord lr, long mark) throws InvalidLogKeyException, LogConfigurationException, LogException, InvalidLogBufferException {
        int markBSN;
        int bsn = this.bmgr.bsnFromMark(mark);
        if (mark < 0L || bsn == 0 && mark != 0L) {
            throw new InvalidLogKeyException(Long.toHexString(mark));
        }
        if (lr == null) {
            lr = new LogRecord(this.config.getBufferSize() * 1024 / 4);
        }
        try {
            if (lr.buffer == null) {
                lr.buffer = this.bmgr.getLogBuffer(-1);
            }
        }
        catch (ClassNotFoundException e) {
            throw new LogConfigurationException(e);
        }
        LogBuffer buffer = lr.buffer;
        try {
            this.bmgr.forceCurrentBuffer();
            this.lfmgr.read(buffer, bsn);
        }
        catch (IOException e) {
            LogFile lf = buffer.lf;
            String msg = "Error reading " + lf.file + " @ position [" + lf.position + "]";
            throw new LogException(msg, e);
        }
        if (buffer.bsn == -1) {
            lr.type = (short)19983;
            return lr;
        }
        int n = markBSN = mark == 0L ? buffer.bsn : this.bmgr.bsnFromMark(mark);
        if (markBSN != buffer.bsn) {
            InvalidLogBufferException lbe = new InvalidLogBufferException("block read [" + buffer.bsn + "] not block requested: " + markBSN);
            throw lbe;
        }
        lr.get(buffer);
        if (mark > 0L && mark > this.bmgr.markFromBsn(markBSN, 0)) {
            while (lr.key < mark) {
                lr.get(buffer);
            }
            if (lr.key != mark) {
                String msg = "The requested mark [" + Long.toHexString(mark) + "] was not found in the log.";
                throw new InvalidLogKeyException(msg);
            }
        }
        return lr;
    }

    public LogRecord getNext(LogRecord lr) throws InvalidLogBufferException, LogException {
        if (lr == null || lr.buffer == null) {
            throw new IllegalArgumentException();
        }
        LogBuffer buffer = lr.buffer;
        lr.get(buffer);
        if (lr.isEOB()) {
            try {
                this.lfmgr.read(buffer, buffer.bsn + 1);
            }
            catch (IOException e) {
                LogFile lf = lr.buffer.lf;
                String msg = "Error reading " + lf.file + " @ position [" + lf.position + "]";
                throw new LogException(msg, e);
            }
            if (buffer.bsn == -1) {
                lr.type = (short)19983;
                return lr;
            }
            lr.get(buffer);
        }
        return lr;
    }

    public String getStats() {
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("<Logger  class='" + name + "'>");
        stats.append(this.bmgr.getStats());
        stats.append(this.lfmgr.getStats());
        stats.append("\n</Logger>\n");
        return stats.toString();
    }

    static {
        $assertionsDisabled = !Logger.class.desiredAssertionStatus();
    }
}

