/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.core.ExtendedWorkspace;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCloneVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.WorkspaceItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.xml.ExportImportFactory;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceImpl
implements ExtendedWorkspace {
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceImpl");
    private final SessionImpl session;
    private final NamespaceRegistryImpl namespaceRegistry;
    private final NodeTypeDataManager nodeTypeManager;
    private final ObservationManager observationManager;
    private final QueryManagerImpl queryManager;
    private final String name;

    public WorkspaceImpl(String name, ExoContainer container, SessionImpl session, ObservationManager observationManager) throws RepositoryException {
        this.session = session;
        this.name = name;
        this.observationManager = observationManager;
        this.namespaceRegistry = (NamespaceRegistryImpl)container.getComponentInstanceOfType(NamespaceRegistry.class);
        this.nodeTypeManager = (NodeTypeDataManager)container.getComponentInstanceOfType(NodeTypeDataManager.class);
        QueryManagerFactory qf = (QueryManagerFactory)container.getComponentInstanceOfType(QueryManagerFactory.class);
        this.queryManager = qf == null ? null : qf.getQueryManager(session);
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        SessionChangesLog changes = new SessionChangesLog(this.session.getId());
        this.clone(srcWorkspace, srcAbsPath, destAbsPath, removeExisting, changes);
        this.session.getTransientNodesManager().getTransactManager().save(changes);
    }

    public void copy(String srcPath, String destPath) throws ItemExistsException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, RepositoryException {
        this.copy(this.getName(), srcPath, destPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        SessionImpl srcSession = null;
        srcSession = this.getName() != srcWorkspace ? this.repository().internalLogin(this.session.getUserState(), srcWorkspace) : this.session;
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The path provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        JCRPath srcNodePath = srcSession.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)srcSession.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), false);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((NodeTypeImpl)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem((NodeData)destParentNode.getData(), new QPathEntry(destNodePath.getInternalPath().getName(), 0), false, ItemType.NODE);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            throw new ItemExistsException("A node with name (" + destAbsPath + ") is already exists.");
        }
        WorkspaceItemDataCopyVisitor initializer = new WorkspaceItemDataCopyVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.nodeTypeManager, srcSession.getTransientNodesManager(), this.session.getTransientNodesManager(), false);
        srcNode.getData().accept(initializer);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(initializer.getItemAddStates(), this.session.getId());
        this.session.getTransientNodesManager().getTransactManager().save(changesLog);
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        RepositoryImpl rep = (RepositoryImpl)this.session.getRepository();
        return rep.getWorkspaceNames();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", true);
        return new ExportImportFactory().getImportHandler((NodeData)node.getData(), uuidBehavior, this.session.getTransientNodesManager().getTransactManager(), this.session.getTransientNodesManager().getTransactManager(), this.nodeTypeManager, this.session.getLocationFactory(), this.session.getValueFactory(), this.getNamespaceRegistry(), this.session.getAccessManager(), this.session.getUserState(), context, (RepositoryImpl)this.session.getRepository(), this.name);
    }

    public String getName() {
        return this.name;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.namespaceRegistry;
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return new NodeTypeManagerImpl(this.session.getLocationFactory(), this.session.getValueFactory(), this.nodeTypeManager, this.session.getTransientNodesManager());
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.observationManager;
    }

    public QueryManager getQueryManager() throws RepositoryException {
        if (this.queryManager == null) {
            throw new RepositoryException("Query Manager Factory not found. Check configuration.");
        }
        return this.queryManager;
    }

    public Session getSession() {
        return this.session;
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", true);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, boolean respectPropertyDefinitionsConstraints) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("respectPropertyDefinitionsConstraints", respectPropertyDefinitionsConstraints);
        this.importXML(parentAbsPath, in, uuidBehavior, context);
    }

    @Override
    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, Map<String, Object> context) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getItem(parentAbsPath);
        if (!node.checkedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (!node.checkLocking()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
        StreamImporter importer = new ExportImportFactory().getStreamImporter((NodeData)node.getData(), uuidBehavior, this.session.getTransientNodesManager().getTransactManager(), this.session.getTransientNodesManager().getTransactManager(), this.nodeTypeManager, this.session.getLocationFactory(), this.session.getValueFactory(), this.getNamespaceRegistry(), this.session.getAccessManager(), this.session.getUserState(), context, (RepositoryImpl)this.session.getRepository(), this.name);
        importer.importStream(in);
    }

    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("The path provided must not have an index on its final element. " + destNodePath.getAsString(false));
        }
        JCRPath srcNodePath = this.session.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)this.session.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), false);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at " + srcAbsPath + " or no node exists one level above " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
            srcNode.checkPermission("remove");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((NodeTypeImpl)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem((NodeData)destParentNode.getData(), new QPathEntry(destNodePath.getInternalPath().getName(), 0), false, ItemType.NODE);
        if (destNode != null && !destNode.getDefinition().allowsSameNameSiblings()) {
            String msg = "A node with name (" + destAbsPath + ") is already exists.";
            throw new ItemExistsException(msg);
        }
        if (!srcNode.checkedOut()) {
            throw new VersionException("Source parent node " + srcNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!srcNode.checkLocking()) {
            throw new LockException("Source parent node " + srcNode.getPath() + " is     locked ");
        }
        ItemDataMoveVisitor initializer = new ItemDataMoveVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.nodeTypeManager, this.session.getTransientNodesManager(), true);
        srcNode.getData().accept(initializer);
        PlainChangesLogImpl changes = new PlainChangesLogImpl(this.session.getId());
        changes.addAll(initializer.getAllStates());
        this.session.getTransientNodesManager().getTransactManager().save(changes);
    }

    public void restore(Version[] versions, boolean removeExisting) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException, InvalidItemStateException {
        this.restoreVersions(versions, removeExisting);
    }

    protected void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting, SessionChangesLog changes) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, RepositoryException {
        if (srcWorkspace.equals(this.getName())) {
            throw new RepositoryException("Source and destination workspace are equals " + this.name);
        }
        JCRPath destNodePath = this.session.getLocationFactory().parseAbsPath(destAbsPath);
        if (destNodePath.isIndexSetExplicitly()) {
            throw new RepositoryException("DestPath should not contain an index " + destAbsPath);
        }
        SessionImpl srcSession = this.repository().internalLogin(this.session.getUserState(), srcWorkspace);
        JCRPath srcNodePath = srcSession.getLocationFactory().parseAbsPath(srcAbsPath);
        NodeImpl srcNode = (NodeImpl)srcSession.getTransientNodesManager().getItem(srcNodePath.getInternalPath(), false);
        NodeImpl destParentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(destNodePath.makeParentPath().getInternalPath(), true);
        if (srcNode == null || destParentNode == null) {
            throw new PathNotFoundException("No node exists at source path " + srcAbsPath + " or no node exists one level above on destenation " + destAbsPath);
        }
        try {
            destParentNode.checkPermission("add_node");
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage());
        }
        destParentNode.validateChildNode(destNodePath.getName().getInternalName(), ((NodeTypeImpl)srcNode.getPrimaryNodeType()).getQName());
        NodeImpl destNode = (NodeImpl)this.session.getTransientNodesManager().getItem((NodeData)destParentNode.getData(), new QPathEntry(destNodePath.getInternalPath().getName(), 0), false, ItemType.NODE);
        ItemState changesItemState = null;
        if (changes != null) {
            changesItemState = changes.getItemState(destNodePath.getInternalPath());
        }
        if (!(destNode == null || changesItemState != null && changesItemState.isDeleted() || destNode.getDefinition().allowsSameNameSiblings())) {
            String msg = "A node with name (" + destAbsPath + ") is already exists.";
            throw new ItemExistsException(msg);
        }
        ItemDataCloneVisitor initializer = new ItemDataCloneVisitor((NodeData)destParentNode.getData(), destNodePath.getName().getInternalName(), this.nodeTypeManager, srcSession.getTransientNodesManager(), this.session.getTransientNodesManager(), removeExisting, changes);
        srcNode.getData().accept(initializer);
        if (removeExisting && initializer.getItemDeletedExistingStates(false).size() > 0) {
            changes.addAll(initializer.getItemDeletedExistingStates(true));
        }
        changes.addAll(initializer.getItemAddStates());
    }

    protected void restoreVersions(Version[] versions, boolean removeExisting) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException, InvalidItemStateException {
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        ArrayList<String> existedIdentifiers = new ArrayList<String>();
        ArrayList<VersionImpl> notExistedVersions = new ArrayList<VersionImpl>();
        LinkedHashMap<VersionImpl, NodeData> existedVersions = new LinkedHashMap<VersionImpl, NodeData>();
        TransactionableDataManager dataManager = this.session.getTransientNodesManager().getTransactManager();
        for (Version v : versions) {
            String versionableIdentifier = v.getContainingHistory().getVersionableUUID();
            NodeData node = (NodeData)dataManager.getItemData(versionableIdentifier);
            if (node != null) {
                existedVersions.put((VersionImpl)v, node);
                existedIdentifiers.add(versionableIdentifier);
                continue;
            }
            NodeData corrNode = null;
            String versionableParentIdentifier = null;
            if (!v.getSession().getWorkspace().getName().equals(this.session.getWorkspace().getName())) {
                TransactionableDataManager vDataManager = ((SessionImpl)v.getSession()).getTransientNodesManager().getTransactManager();
                corrNode = (NodeData)vDataManager.getItemData(versionableIdentifier);
                if (corrNode != null) {
                    versionableParentIdentifier = corrNode.getParentIdentifier();
                } else {
                    log.warn((Object)("Workspace.restore(). Correspondent node is not found " + versionableIdentifier));
                }
            }
            if (versionableParentIdentifier != null && existedIdentifiers.contains(versionableParentIdentifier)) {
                notExistedVersions.add((VersionImpl)v);
                continue;
            }
            throw new VersionException("No such node (for version, from the array of versions, that corresponds to a missing node in the workspace, there must also be a parent in the array). UUID: " + versionableIdentifier);
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        for (VersionImpl v : existedVersions.keySet()) {
            try {
                NodeData node = (NodeData)existedVersions.get(v);
                NodeData destParent = (NodeData)dataManager.getItemData(node.getParentIdentifier());
                NodeData vh = (NodeData)dataManager.getItemData(v.getParentIdentifier());
                VersionHistoryDataHelper historyHelper = new VersionHistoryDataHelper(vh, dataManager, this.nodeTypeManager);
                changesLog.addAll(v.restoreLog(destParent, node.getQPath().getName(), historyHelper, this.session, removeExisting, changesLog).getAllStates());
            }
            catch (ItemExistsException e) {
                throw new ItemExistsException("Workspace restore. Can't restore a node. " + v.getContainingHistory().getVersionableUUID() + ". " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Workspace restore. Can't restore a node. " + v.getContainingHistory().getVersionableUUID() + ". Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        for (VersionImpl v : notExistedVersions) {
            String versionableIdentifier = v.getContainingHistory().getVersionableUUID();
            try {
                ItemData node = null;
                for (ItemState change : changesLog.getAllStates()) {
                    if (!change.isNode() || !change.isAdded() || !((NodeData)change.getData()).getIdentifier().equals(versionableIdentifier)) continue;
                    node = (NodeData)change.getData();
                    break;
                }
                if (node != null) {
                    NodeData destParent = (NodeData)dataManager.getItemData(node.getParentIdentifier());
                    NodeData vh = (NodeData)dataManager.getItemData(v.getParentIdentifier());
                    VersionHistoryDataHelper historyHelper = new VersionHistoryDataHelper(vh, dataManager, this.nodeTypeManager);
                    changesLog.addAll(v.restoreLog(destParent, node.getQPath().getName(), historyHelper, this.session, removeExisting, changesLog).getAllStates());
                    continue;
                }
                throw new VersionException("No such node restored before (for version, from the array of versions, that corresponds to a missing node in the workspace, there must also be a parent in the array). UUID: " + versionableIdentifier);
            }
            catch (ItemExistsException e) {
                throw new ItemExistsException("Workspace restore. Can't restore a node not existed before. " + versionableIdentifier + ". " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Workspace restore. Can't restore a node not existed before. " + versionableIdentifier + ". Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        dataManager.save(changesLog);
    }

    private RepositoryImpl repository() {
        return (RepositoryImpl)this.session.getRepository();
    }

    public NodeTypeDataManager getNodeTypesHolder() throws RepositoryException {
        return this.nodeTypeManager;
    }
}

