/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class CharacterEncoder {
    private PrintStream printStream;
    private char[] pemArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-'};

    private int bytesPerLine() {
        return 57;
    }

    private int bytesPerAtom() {
        return 3;
    }

    private void encodeLineSuffix(OutputStream aStream) throws Exception {
        this.printStream.println();
    }

    private void encodeBufferSuffix(OutputStream aStream) throws Exception {
    }

    private void encodeBufferPrefix(OutputStream aStream) throws Exception {
        this.printStream = new PrintStream(aStream);
    }

    private void encodeLinePrefix(OutputStream aStream, int aLength) throws Exception {
    }

    private int readFully(InputStream in, byte[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            int q = in.read();
            if (q == -1) {
                return i;
            }
            buffer[i] = (byte)q;
        }
        return buffer.length;
    }

    public String encodeBuffer(byte[] aBuffer) {
        ByteArrayInputStream in = new ByteArrayInputStream(aBuffer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encodeBuffer(in, out);
        }
        catch (Exception IOException2) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return out.toString().trim();
    }

    public void encodeBuffer(InputStream in, OutputStream out) throws Exception {
        int numBytes;
        byte[] tmpbuffer = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(out);
        while ((numBytes = this.readFully(in, tmpbuffer)) != -1) {
            this.encodeLinePrefix(out, numBytes);
            for (int j = 0; j < numBytes; j += this.bytesPerAtom()) {
                if (j + this.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(out, tmpbuffer, j, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(out, tmpbuffer, j, numBytes - j);
            }
            this.encodeLineSuffix(out);
            if (numBytes >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(out);
    }

    private void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
        if (len == 1) {
            byte a = data[offset];
            int b = 0;
            boolean c = false;
            outStream.write(this.pemArray[a >>> 2 & 0x3F]);
            outStream.write(this.pemArray[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            outStream.write(61);
            outStream.write(61);
        } else if (len == 2) {
            byte a = data[offset];
            byte b = data[offset + 1];
            int c = 0;
            outStream.write(this.pemArray[a >>> 2 & 0x3F]);
            outStream.write(this.pemArray[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            outStream.write(this.pemArray[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
            outStream.write(61);
        } else {
            byte a = data[offset];
            byte b = data[offset + 1];
            byte c = data[offset + 2];
            outStream.write(this.pemArray[a >>> 2 & 0x3F]);
            outStream.write(this.pemArray[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            outStream.write(this.pemArray[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
            outStream.write(this.pemArray[c & 0x3F]);
        }
    }
}

