/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import javax.transaction.xa.Xid;
import org.enhydra.jdbc.standard.StandardXADataSource;

public class StandardXAStatefulConnection {
    public static int nextId;
    public int id;
    public Connection con;
    private int state;
    public StandardXADataSource dataSource;
    Xid xid;
    public boolean commitOnPrepare;
    long timeout;
    boolean timedOut;

    public StandardXAStatefulConnection(StandardXADataSource dataSource, Connection con) {
        this.con = con;
        this.dataSource = dataSource;
        this.id = ++nextId;
        this.state = 6;
        dataSource.log.debug("StandardXAStatefulConnection created");
    }

    synchronized void setState(int newState) {
        this.dataSource.log.debug("StandardXAStatefulConnection:setState Stateful connection: " + this.id + " (state before=" + this.state + ")");
        this.state = newState;
        this.dataSource.log.debug("StandardXAStatefulConnection:setState Stateful connection: " + this.id + " (state after=" + this.state + ")");
    }

    int getState() {
        return this.state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardXAStatefulConnection:\n");
        sb.append("     commit on prepare =<" + this.commitOnPrepare + ">\n");
        sb.append("     timed out =<" + this.timedOut + ">\n");
        sb.append("     id =<" + this.id + ">\n");
        sb.append("     state =<" + this.state + ">\n");
        sb.append("     time out =<" + this.timeout + ">\n");
        sb.append("     xid =<" + this.xid + ">\n");
        return sb.toString();
    }
}

