/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.TOC;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFSettings;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.EndnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFDocument
extends POIXMLDocument {
    private CTDocument1 ctDocument;
    private XWPFSettings settings;
    protected List<XWPFComment> comments;
    protected List<XWPFHyperlink> hyperlinks;
    protected List<XWPFParagraph> paragraphs;
    protected List<XWPFTable> tables;
    protected Map<Integer, XWPFFootnote> footnotes;
    protected Map<Integer, XWPFFootnote> endnotes;
    private XWPFHeaderFooterPolicy headerFooterPolicy;

    public XWPFDocument(OPCPackage pkg) throws IOException {
        super(XWPFDocument.ensureWriteAccess(pkg));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument(InputStream is) throws IOException {
        super(PackageHelper.open(is));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument() {
        super(XWPFDocument.newPackage());
        this.onDocumentCreate();
    }

    @Override
    protected void onDocumentRead() throws IOException {
        this.hyperlinks = new ArrayList<XWPFHyperlink>();
        this.comments = new ArrayList<XWPFComment>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        this.footnotes = new HashMap<Integer, XWPFFootnote>();
        this.endnotes = new HashMap<Integer, XWPFFootnote>();
        try {
            DocumentDocument doc = DocumentDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.ctDocument = doc.getDocument();
            CTBody body = this.ctDocument.getBody();
            this.initFootnotes();
            for (CTP cTP : body.getPArray()) {
                this.paragraphs.add(new XWPFParagraph(cTP, this));
            }
            for (CTP cTP : body.getTblArray()) {
                this.tables.add(new XWPFTable(this, (CTTbl)cTP));
            }
            if (doc.getDocument().getBody().getSectPr() != null) {
                this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
            }
            for (POIXMLDocumentPart p : this.getRelations()) {
                String relation = p.getPackageRelationship().getRelationshipType();
                if (relation.equals(XWPFRelation.COMMENT.getRelation())) {
                    CommentsDocument commentsDocument = CommentsDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
                    for (CTComment ctcomment : commentsDocument.getComments().getCommentArray()) {
                        this.comments.add(new XWPFComment(ctcomment));
                    }
                    continue;
                }
                if (!relation.equals(XWPFRelation.SETTINGS.getRelation())) continue;
                this.settings = (XWPFSettings)p;
            }
            this.initHyperlinks();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    private void initHyperlinks() {
        try {
            for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation())) {
                this.hyperlinks.add(new XWPFHyperlink(rel.getId(), rel.getTargetURI().toString()));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private void initFootnotes() throws XmlException, IOException {
        for (POIXMLDocumentPart p : this.getRelations()) {
            String relation = p.getPackageRelationship().getRelationshipType();
            if (relation.equals(XWPFRelation.FOOTNOTE.getRelation())) {
                FootnotesDocument footnotesDocument = FootnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
                for (CTFtnEdn ctFtnEdn : footnotesDocument.getFootnotes().getFootnoteArray()) {
                    this.footnotes.put(ctFtnEdn.getId().intValue(), new XWPFFootnote(this, ctFtnEdn));
                }
                continue;
            }
            if (!relation.equals(XWPFRelation.ENDNOTE.getRelation())) continue;
            EndnotesDocument endnotesDocument = EndnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
            for (CTFtnEdn ctFtnEdn : endnotesDocument.getEndnotes().getEndnoteArray()) {
                this.endnotes.put(ctFtnEdn.getId().intValue(), new XWPFFootnote(this, ctFtnEdn));
            }
        }
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage pkg = OPCPackage.create(PackageHelper.createTempFile());
            PackagePartName corePartName = PackagingURIHelper.createPartName(XWPFRelation.DOCUMENT.getDefaultFileName());
            pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            pkg.createPart(corePartName, XWPFRelation.DOCUMENT.getContentType());
            pkg.getPackageProperties().setCreatorProperty("Apache POI");
            return pkg;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    protected void onDocumentCreate() {
        this.hyperlinks = new ArrayList<XWPFHyperlink>();
        this.comments = new ArrayList<XWPFComment>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        this.ctDocument = CTDocument1.Factory.newInstance();
        this.ctDocument.addNewBody();
        this.settings = (XWPFSettings)this.createRelationship(XWPFRelation.SETTINGS, XWPFFactory.getInstance());
        POIXMLProperties.ExtendedProperties expProps = this.getProperties().getExtendedProperties();
        expProps.getUnderlyingProperties().setApplication("Apache POI");
    }

    public CTDocument1 getDocument() {
        return this.ctDocument;
    }

    public Iterator<XWPFParagraph> getParagraphsIterator() {
        return this.paragraphs.iterator();
    }

    public XWPFParagraph[] getParagraphs() {
        return this.paragraphs.toArray(new XWPFParagraph[this.paragraphs.size()]);
    }

    public Iterator<XWPFTable> getTablesIterator() {
        return this.tables.iterator();
    }

    public XWPFHyperlink getHyperlinkByID(String id) {
        for (XWPFHyperlink link : this.hyperlinks) {
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    public XWPFFootnote getFootnoteByID(int id) {
        return this.footnotes.get(id);
    }

    public XWPFFootnote getEndnoteByID(int id) {
        return this.endnotes.get(id);
    }

    public Collection<XWPFFootnote> getFootnotes() {
        return this.footnotes == null ? new ArrayList() : this.footnotes.values();
    }

    public XWPFHyperlink[] getHyperlinks() {
        return this.hyperlinks.toArray(new XWPFHyperlink[this.hyperlinks.size()]);
    }

    public XWPFComment getCommentByID(String id) {
        for (XWPFComment comment : this.comments) {
            if (!comment.getId().equals(id)) continue;
            return comment;
        }
        return null;
    }

    public XWPFComment[] getComments() {
        return this.comments.toArray(new XWPFComment[this.comments.size()]);
    }

    public PackagePart getPartById(String id) {
        try {
            return this.getTargetPart(this.getCorePart().getRelationship(id));
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XWPFHeaderFooterPolicy getHeaderFooterPolicy() {
        return this.headerFooterPolicy;
    }

    public CTStyles getStyle() throws XmlException, IOException {
        PackagePart[] parts;
        try {
            parts = this.getRelatedByType(XWPFRelation.STYLES.getRelation());
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        if (parts.length != 1) {
            throw new IllegalStateException("Expecting one Styles document part, but found " + parts.length);
        }
        StylesDocument sd = StylesDocument.Factory.parse((InputStream)parts[0].getInputStream());
        return sd.getStyles();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject")) {
            embedds.add(this.getTargetPart(rel));
        }
        for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package")) {
            embedds.add(this.getTargetPart(rel));
        }
        return embedds;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDocument1.type.getName().getNamespaceURI(), "document"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        map.put("urn:schemas-microsoft-com:office:office", "o");
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("urn:schemas-microsoft-com:vml", "v");
        map.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        map.put("urn:schemas-microsoft-com:office:word", "w10");
        map.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctDocument.save(out, xmlOptions);
        out.close();
    }

    public XWPFParagraph createParagraph() {
        return new XWPFParagraph(this.ctDocument.getBody().addNewP(), this);
    }

    public XWPFTable createTable() {
        return new XWPFTable(this, this.ctDocument.getBody().addNewTbl());
    }

    public XWPFTable createTable(int rows, int cols) {
        return new XWPFTable(this, this.ctDocument.getBody().addNewTbl(), rows, cols);
    }

    public void createTOC() {
        CTSdtBlock block = this.getDocument().getBody().addNewSdt();
        TOC toc = new TOC(block);
        boolean i = true;
        Iterator<XWPFParagraph> iterator = this.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph par = iterator.next();
            String parStyle = par.getStyle();
            if (parStyle == null || !parStyle.substring(0, 7).equals("Heading")) continue;
            try {
                int level = Integer.valueOf(parStyle.substring("Heading".length()));
                toc.addRow(level, par.getText(), 1, "112723803");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEnforcedReadonlyProtection() {
        return this.settings.isEnforcedWith(STDocProtect.READ_ONLY);
    }

    public boolean isEnforcedFillingFormsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.FORMS);
    }

    public boolean isEnforcedCommentsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.COMMENTS);
    }

    public boolean isEnforcedTrackedChangesProtection() {
        return this.settings.isEnforcedWith(STDocProtect.TRACKED_CHANGES);
    }

    public void enforceReadonlyProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY);
    }

    public void enforceFillingFormsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS);
    }

    public void enforceCommentsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS);
    }

    public void enforceTrackedChangesProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES);
    }

    public void removeProtectionEnforcement() {
        this.settings.removeEnforcement();
    }
}

