/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorStatus<K>
implements Iterator<K> {
    private final Iterator<K> delegate;
    private int index;

    public IteratorStatus(Iterator<K> delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("No iterator is provided");
        }
        this.delegate = delegate;
        this.index = -1;
    }

    public IteratorStatus(Collection<K> c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("No collection is provided");
        }
        this.delegate = c.iterator();
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() throws IllegalStateException {
        if (this.index == -1) {
            throw new IllegalStateException("No element has been iterated so far");
        }
        return this.index == 0;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public K next() {
        K o = this.delegate.next();
        ++this.index;
        return o;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

