/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, type=UIResourceForm.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class})})
public class UIResourceForm
extends UIForm {
    public static final String FIElD_NAME = "name";
    public static final String FIElD_TEXTTOMODIFY = "textToModify";
    public static final String FIElD_FILETOUPLOAD = "fileToUpload";
    private Node contentNode_;
    private Property mime_;
    private Session session_;

    public UIResourceForm() throws Exception {
        this.setMultiPart(true);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIElD_NAME, FIElD_NAME, null));
    }

    public void setContentNode(Node node, Session session) throws RepositoryException {
        this.session_ = session;
        this.contentNode_ = node;
        this.mime_ = node.getProperty("jcr:mimeType");
        String name = node.getParent().getName();
        this.getUIStringInput(FIElD_NAME).setValue((Object)name);
        if (this.mime_.getString().startsWith("text")) {
            String contentText = node.getProperty("jcr:data").getString();
            this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIElD_TEXTTOMODIFY, FIElD_TEXTTOMODIFY, contentText));
        } else {
            this.getUIStringInput(FIElD_NAME).setEditable(false);
            UIFormUploadInput uiInput = new UIFormUploadInput(FIElD_FILETOUPLOAD, FIElD_FILETOUPLOAD);
            uiInput.setAutoUpload(true);
            this.addUIFormInput((UIFormInput)uiInput);
        }
    }

    public boolean isText() throws RepositoryException {
        return this.mime_.getString().startsWith("text");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIResourceForm> {
        public void execute(Event<UIResourceForm> event) throws Exception {
            UIResourceForm uiResourceForm = (UIResourceForm)((Object)event.getSource());
            uiResourceForm.setRenderSibling(UIDocumentInfo.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIResourceForm> {
        public void execute(Event<UIResourceForm> event) throws Exception {
            UIResourceForm uiResourceForm = (UIResourceForm)((Object)event.getSource());
            Property prop = uiResourceForm.contentNode_.getProperty("jcr:mimeType");
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiResourceForm.getAncestorOfType(UIJCRExplorer.class);
            if (prop.getString().startsWith("text")) {
                String text = (String)uiResourceForm.getUIFormTextAreaInput(UIResourceForm.FIElD_TEXTTOMODIFY).getValue();
                uiResourceForm.contentNode_.setProperty("jcr:data", text);
            } else {
                UIFormUploadInput fileUpload = (UIFormUploadInput)uiResourceForm.getUIInput(UIResourceForm.FIElD_FILETOUPLOAD);
                InputStream content = fileUpload.getUploadDataAsStream();
                uiResourceForm.contentNode_.setProperty("jcr:data", content);
            }
            if (uiResourceForm.session_ != null) {
                uiResourceForm.session_.save();
            } else {
                uiJCRExplorer.getSession().save();
            }
            uiResourceForm.setRenderSibling(UIDocumentInfo.class);
        }
    }
}

