/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.xmlbeans.XmlException;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSXPPTDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        XSLFPowerPointExtractor ppe;
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        if (is.available() == 0) {
            String string = "";
            return string;
        }
        try {
            ppe = new XSLFPowerPointExtractor(OPCPackage.open((InputStream)is));
        }
        catch (IOException e) {
            throw new DocumentReadException("Can't open presentation.", e);
        }
        catch (OpenXML4JRuntimeException e) {
            throw new DocumentReadException("Can't open presentation.", e);
        }
        catch (OpenXML4JException e) {
            throw new DocumentReadException("Can't open presentation.", e);
        }
        catch (XmlException e) {
            throw new DocumentReadException("Can't open presentation.", e);
        }
        String string = ppe.getText(true, true);
        return string;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        try {
            reader.readDCProperties((POIXMLDocument)new XSLFSlideShow(OPCPackage.open((InputStream)is)));
        }
        catch (InvalidFormatException e) {
            throw new DocumentReadException("Can't read properties from OOXML document", e);
        }
        catch (OpenXML4JException e) {
            throw new DocumentReadException("Can't read properties from OOXML document", e);
        }
        catch (XmlException e) {
            throw new DocumentReadException("Can't read properties from OOXML document", e);
        }
        return reader.getProperties();
    }
}

