/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.exoplatform.wsqa.httpclient.HttpResponseHeader;
import org.exoplatform.wsqa.httpclient.URI;

public class HttpResponseBody {
    private static byte[] EMPTY_BODY = new byte[0];
    private ByteArrayOutputStream originalData_;

    public HttpResponseBody(InputStream is, URI uri, HttpResponseHeader header) throws Exception {
        if (header.getStatusCode() == 304) {
            return;
        }
        if (header.getStatusCode() == 302) {
            return;
        }
        int contentLength = header.getContentLengthAsInteger();
        int totalRead = 0;
        if (contentLength > 0) {
            totalRead = this.parseBody(is, uri, header, contentLength);
        } else if (contentLength != 0) {
            totalRead = this.parseBody(is, uri, header);
        }
        if (contentLength > 0 && totalRead != contentLength) {
            System.out.println("\nWARNING: total read = " + totalRead + " but content length = " + contentLength + "  \n URI: " + uri.getURI());
        }
    }

    public byte[] getBodyDataAsByte() {
        if (this.originalData_ == null) {
            return EMPTY_BODY;
        }
        return this.originalData_.toByteArray();
    }

    public byte[] getOriginalBodyDataAsByte() {
        if (this.originalData_ == null) {
            return EMPTY_BODY;
        }
        return this.originalData_.toByteArray();
    }

    private int parseBody(InputStream is, URI uri, HttpResponseHeader header, int bodySize) throws Exception {
        int read;
        this.originalData_ = new ByteArrayOutputStream();
        int totalRead = 0;
        byte[] buf = new byte[4092];
        do {
            if ((read = is.read(buf)) == -1) {
                this.cannotDetectEOF(uri, header);
                break;
            }
            this.originalData_.write(buf, 0, read);
        } while ((totalRead += read) < bodySize);
        if (totalRead != bodySize) {
            throw new Exception("Expect body size " + bodySize + ", but the total read " + totalRead);
        }
        return totalRead;
    }

    private int parseBody(InputStream is, URI uri, HttpResponseHeader header) throws Exception {
        this.originalData_ = new ByteArrayOutputStream();
        int totalRead = 0;
        while (true) {
            int code;
            if ((code = is.read()) == -1) {
                this.cannotDetectEOF(uri, header);
                break;
            }
            if (code == 48) {
                ++totalRead;
                this.originalData_.write(code);
                int c1 = is.read();
                int c2 = is.read();
                int c3 = is.read();
                int c4 = is.read();
                if (c1 != -1) {
                    ++totalRead;
                    this.originalData_.write(c1);
                }
                if (c2 != -1) {
                    ++totalRead;
                    this.originalData_.write(c2);
                }
                if (c3 != -1) {
                    ++totalRead;
                    this.originalData_.write(c3);
                }
                if (c4 != -1) {
                    ++totalRead;
                    this.originalData_.write(c4);
                }
                if (c1 != 13 || c2 != 10 || c3 != 13 || c4 != 10) continue;
                break;
            }
            ++totalRead;
            this.originalData_.write(code);
        }
        return totalRead;
    }

    private void cannotDetectEOF(URI uri, HttpResponseHeader header) {
        System.out.println("--------------------------------------------------------");
        System.out.println("Cannot detect EOF for " + uri.getURI());
        System.out.println("Status " + header.getStatusCode() + ", Status String " + header.getStatusString());
        System.out.println("--------------------------------------------------------");
    }
}

