/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.PortletFutureCache;
import org.picocontainer.Startable;

public class FragmentCacheService
implements Startable {
    private static final Log log = ExoLogger.getLogger(FragmentCacheService.class);
    final PortletFutureCache cache;

    public FragmentCacheService(InitParams params) {
        int cleanupCache = -1;
        if (params.getValueParam("cleanup-cache") != null) {
            String cleanupCacheConfig = params.getValueParam("cleanup-cache").getValue();
            try {
                cleanupCache = Integer.parseInt(cleanupCacheConfig);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid cleanup-cache setting " + cleanupCacheConfig));
            }
        }
        this.cache = new PortletFutureCache(log, cleanupCache);
    }

    public int getCleanupCache() {
        return this.cache.getCleanupCache();
    }

    public void setCleanupCache(int cleanupCache) {
        this.cache.updateCleanupCache(cleanupCache);
    }

    public void start() {
        this.cache.start();
    }

    public void stop() {
        this.cache.stop();
    }
}

