/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.HasRemovePermissionFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectRestorePath;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={RestoreFromTrashActionListener.class})})
public class RestoreFromTrashManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsInTrashFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new HasRemovePermissionFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger(RestoreFromTrashManageComponent.class);

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void restoreFromTrash(String srcPath, Event<RestoreFromTrashManageComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((RestoreFromTrashManageComponent)((Object)event.getSource())).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        Node node = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            node = uiExplorer.getNodeByPath(srcPath, session, false);
            srcPath = node.getPath();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        RestoreFromTrashManageComponent.confirmToRestore(node, srcPath, event);
    }

    private static void confirmToRestore(Node node, String srcPath, Event<RestoreFromTrashManageComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((RestoreFromTrashManageComponent)((Object)event.getSource())).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
        String restorePath = node.getProperty("exo:restorePath").getString();
        String restoreWs = node.getProperty("exo:restoreWorkspace").getString();
        Session session = uiExplorer.getSessionByWorkspace(restoreWs);
        NodeFinder nodeFinder = (NodeFinder)uiExplorer.getApplicationComponent(NodeFinder.class);
        try {
            nodeFinder.getItem(session, restorePath);
        }
        catch (PathNotFoundException e) {
            RestoreFromTrashManageComponent.doRestore(srcPath, node, event);
            return;
        }
        RestoreFromTrashManageComponent.doRestore(srcPath, node, event);
    }

    public static void doRestore(String srcPath, Node node, Event<? extends UIComponent> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        TrashService trashService = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
        UIApplication uiApp = (UIApplication)((UIComponent)event.getSource()).getAncestorOfType(UIApplication.class);
        String restorePath = node.getProperty("exo:restorePath").getString();
        String restoreWs = node.getProperty("exo:restoreWorkspace").getString();
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            PortletPreferences portletPrefs = uiExplorer.getPortletPreferences();
            String repository = uiExplorer.getRepositoryName();
            String trashWorkspace = portletPrefs.getValue(Utils.TRASH_WORKSPACE, "");
            String trashHomeNodePath = portletPrefs.getValue(Utils.TRASH_HOME_NODE_PATH, "");
            Session trashSession = uiExplorer.getSessionByWorkspace(trashWorkspace);
            Node trashHomeNode = (Node)trashSession.getItem(trashHomeNodePath);
            SessionProvider sessionProvider = uiExplorer.getSessionProvider();
            try {
                trashService.restoreFromTrash(trashHomeNode, srcPath, repository, sessionProvider);
                uiExplorer.updateAjax(event);
            }
            catch (PathNotFoundException e) {
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                UISelectRestorePath uiSelectRestorePath = (UISelectRestorePath)uiWorkingArea.createUIComponent(UISelectRestorePath.class, null, null);
                uiSelectRestorePath.setTrashHomeNode(trashHomeNode);
                uiSelectRestorePath.setSrcPath(srcPath);
                uiSelectRestorePath.setRepository(repository);
                uiPopupContainer.activate((UIComponent)uiSelectRestorePath, 600, 300);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            }
            try {
                Session session = uiExplorer.getSessionByWorkspace(restoreWs);
                NodeFinder nodeFinder = (NodeFinder)uiExplorer.getApplicationComponent(NodeFinder.class);
                Node restoredNode = (Node)nodeFinder.getItem(session, restorePath);
                WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
                List categories = ((TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class)).getAllCategories(restoredNode);
                for (Node categoryNode : categories) {
                    wcmComposer.updateContents(categoryNode.getSession().getRepository().toString(), categoryNode.getSession().getWorkspace().getName(), categoryNode.getPath(), new HashMap());
                }
                String parentPath = restoredNode.getParent().getPath();
                String parentRepo = restoredNode.getSession().getRepository().toString();
                String parentWSpace = restoredNode.getSession().getWorkspace().getName();
                wcmComposer.updateContents(parentRepo, parentWSpace, parentPath, new HashMap());
            }
            catch (Exception e) {}
        }
        catch (PathNotFoundException e) {
            LOG.error((Object)("Path not found! Maybe, it was removed or path changed, can't restore node :" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (LockException e) {
            LOG.error((Object)("node is locked, can't restore node :" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (VersionException e) {
            LOG.error((Object)("node is checked in, can't restore node:" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (AccessDeniedException e) {
            LOG.error((Object)("access denied, can't restore of node:" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (ConstraintViolationException e) {
            LOG.error((Object)("access denied, can't restore of node:" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreFromTrashActionListener
    extends UIWorkingAreaActionListener<RestoreFromTrashManageComponent> {
        public void restoreFromTrashManage(Event<RestoreFromTrashManageComponent> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            if (srcPath.indexOf(59) > -1) {
                this.multiRestoreFromTrash(srcPath.split(";"), event);
            } else {
                RestoreFromTrashManageComponent.restoreFromTrash(srcPath, (Event<RestoreFromTrashManageComponent>)event);
            }
        }

        private void multiRestoreFromTrash(String[] paths, Event<RestoreFromTrashManageComponent> event) throws Exception {
            for (String path : paths) {
                if (!this.acceptForMultiNode(event, path)) continue;
                RestoreFromTrashManageComponent.restoreFromTrash(path, (Event<RestoreFromTrashManageComponent>)event);
            }
        }

        public void processEvent(Event<RestoreFromTrashManageComponent> event) throws Exception {
            this.restoreFromTrashManage(event);
        }
    }
}

