/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.Writer;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.StateAwareResponse;
import org.exoplatform.commons.utils.WriterPrinter;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletURLBuilder;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestContext
extends WebuiRequestContext {
    private String windowId_;
    private PortletRequest request_;
    private PortletResponse response_;
    private Writer writer_;
    private boolean hasProcessAction_ = false;
    private final PortletURLBuilder urlBuilder;

    public PortletRequestContext(WebuiApplication app, Writer writer, PortletRequest req, PortletResponse res) {
        super(app);
        this.init(writer, req, res);
        this.setSessionId(req.getPortletSession(true).getId());
        this.urlBuilder = new PortletURLBuilder();
    }

    public void init(Writer writer, PortletRequest req, PortletResponse res) {
        this.request_ = req;
        this.response_ = res;
        this.writer_ = new WriterPrinter(writer);
        this.windowId_ = req.getWindowID();
    }

    @Override
    public void setUIApplication(UIApplication uiApplication) throws Exception {
        this.uiApplication_ = uiApplication;
        this.appRes_ = this.getApplication().getResourceBundle(this.getParentAppRequestContext().getLocale());
    }

    public final String getRequestParameter(String name) {
        return this.request_.getParameter(name);
    }

    public final String[] getRequestParameterValues(String name) {
        return this.request_.getParameterValues(name);
    }

    public Orientation getOrientation() {
        return this.parentAppRequestContext_.getOrientation();
    }

    @Override
    public String getRequestContextPath() {
        return this.request_.getContextPath();
    }

    @Override
    public String getPortalContextPath() {
        if (this.parentAppRequestContext_ instanceof WebuiRequestContext) {
            return ((WebuiRequestContext)this.parentAppRequestContext_).getPortalContextPath();
        }
        return null;
    }

    public PortletRequest getRequest() {
        return this.request_;
    }

    public PortletResponse getResponse() {
        return this.response_;
    }

    public String getRemoteUser() {
        return this.parentAppRequestContext_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public PortletMode getApplicationMode() {
        return this.request_.getPortletMode();
    }

    public void setApplicationMode(PortletMode mode) throws PortletModeException {
        if (!(this.response_ instanceof StateAwareResponse)) {
            throw new PortletModeException("The portlet don't support to set a portlet mode by current runtime environment", mode);
        }
        StateAwareResponse res = (StateAwareResponse)this.response_;
        res.setPortletMode(mode);
    }

    public Writer getWriter() throws Exception {
        return this.writer_;
    }

    public void setWriter(Writer writer) {
        this.writer_ = writer;
    }

    public final boolean useAjax() {
        return this.getParentAppRequestContext().useAjax();
    }

    @Override
    public void sendRedirect(String url) throws Exception {
        this.setResponseComplete(true);
        if (this.response_ instanceof ActionResponse) {
            ((ActionResponse)this.response_).sendRedirect(url);
        }
    }

    public boolean hasProcessAction() {
        return this.hasProcessAction_;
    }

    public void setProcessAction(boolean b) {
        this.hasProcessAction_ = b;
    }

    @Override
    public URLBuilder<UIComponent> getURLBuilder() {
        RenderResponse renderRes = (RenderResponse)this.response_;
        this.urlBuilder.setBaseURL(renderRes.createActionURL().toString());
        return this.urlBuilder;
    }

    public String getWindowId() {
        return this.windowId_;
    }
}

