/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.IOException;
import java.util.Properties;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableSimpleFileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileValueStorage;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;

public class CASableSimpleFileValueStorage
extends FileValueStorage {
    private ValueContentAddressStorage vcas;
    private String digestAlgo;

    public CASableSimpleFileValueStorage(FileCleaner cleaner) {
        super(cleaner);
    }

    public void init(Properties props, ValueDataResourceHolder resources) throws IOException, RepositoryConfigurationException {
        super.init(props, resources);
        this.digestAlgo = props.getProperty("digest-algo");
        String vcasType = props.getProperty("vcas-type");
        try {
            this.vcas = (ValueContentAddressStorage)Class.forName(vcasType).newInstance();
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        this.vcas.init(props);
    }

    public ValueIOChannel openIOChannel() throws IOException {
        return new CASableSimpleFileIOChannel(this.rootDir, this.cleaner, this.id, this.resources, this.vcas, this.digestAlgo);
    }
}

