/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.marshall.CacheMarshaller210;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMarshaller300
extends CacheMarshaller210 {
    @Override
    protected void marshallObject(Object o, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        if (o != null && o.getClass().isArray() && this.isKnownType(o.getClass().getComponentType())) {
            this.marshallArray(o, out, refMap);
        } else {
            super.marshallObject(o, out, refMap);
        }
    }

    protected boolean isKnownType(Class c) {
        return c.equals(Object.class) || c.isPrimitive() || c.equals(Character.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(Byte.class) || c.equals(Boolean.class) || c.equals(Short.class) || c.equals(Float.class) || c.equals(Double.class);
    }

    protected void marshallArray(Object o, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        out.writeByte(24);
        Class<?> arrayTypeClass = o.getClass().getComponentType();
        int sz = Array.getLength(o);
        this.writeUnsignedInt(out, sz);
        boolean isPrim = arrayTypeClass.isPrimitive();
        if (!isPrim && arrayTypeClass.equals(Object.class)) {
            out.writeByte(29);
            for (int i = 0; i < sz; ++i) {
                this.marshallObject(Array.get(o, i), out, refMap);
            }
        } else if (arrayTypeClass.equals(Byte.TYPE) || arrayTypeClass.equals(Byte.class)) {
            out.writeByte(25);
            out.writeBoolean(isPrim);
            if (isPrim) {
                out.write((byte[])o);
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeByte(((Byte)Array.get(o, i)).byteValue());
                }
            }
        } else if (arrayTypeClass.equals(Integer.TYPE) || arrayTypeClass.equals(Integer.class)) {
            out.writeByte(6);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeInt(Array.getInt(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeInt((Integer)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Long.TYPE) || arrayTypeClass.equals(Long.class)) {
            out.writeByte(7);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeLong(Array.getLong(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeLong((Long)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Boolean.TYPE) || arrayTypeClass.equals(Boolean.class)) {
            out.writeByte(8);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeBoolean(Array.getBoolean(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeBoolean((Boolean)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Character.TYPE) || arrayTypeClass.equals(Character.class)) {
            out.writeByte(26);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeChar(Array.getChar(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeChar(((Character)Array.get(o, i)).charValue());
                }
            }
        } else if (arrayTypeClass.equals(Short.TYPE) || arrayTypeClass.equals(Short.class)) {
            out.writeByte(20);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeShort(Array.getShort(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeShort(((Short)Array.get(o, i)).shortValue());
                }
            }
        } else if (arrayTypeClass.equals(Float.TYPE) || arrayTypeClass.equals(Float.class)) {
            out.writeByte(27);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeFloat(Array.getFloat(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeFloat(((Float)Array.get(o, i)).floatValue());
                }
            }
        } else if (arrayTypeClass.equals(Double.TYPE) || arrayTypeClass.equals(Double.class)) {
            out.writeByte(28);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeDouble(Array.getDouble(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeDouble((Double)Array.get(o, i));
                }
            }
        } else {
            throw new CacheException("Unknown array type!");
        }
    }
}

