/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form;

import java.util.HashMap;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DialogFormField {
    protected final String SEPARATOR = "=";
    protected final String JCR_PATH = "jcrPath=";
    protected final String EDITABLE = "editable=";
    protected final String ONCHANGE = "onchange=";
    protected final String OPTIONS = "options=";
    protected final String TYPE = "type=";
    protected final String VISIBLE = "visible=";
    protected final String NODETYPE = "nodetype=";
    protected final String MIXINTYPE = "mixintype=";
    protected final String VALIDATE = "validate=";
    protected final String SELECTOR_ACTION = "selectorAction=";
    protected final String SELECTOR_CLASS = "selectorClass=";
    protected final String SELECTOR_ICON = "selectorIcon=";
    protected final String SELECTOR_PARAMS = "selectorParams=";
    protected final String WORKSPACE_FIELD = "workspaceField=";
    protected final String SCRIPT = "script=";
    protected final String SCRIPT_PARAMS = "scriptParams=";
    protected final String MULTI_VALUES = "multiValues=";
    protected final String REFERENCE = "reference=";
    protected final String REPOSITORY = "repository";
    protected final String DEFAULT_VALUES = "defaultValues=";
    protected final String ROW_SIZE = "rows=";
    protected final String COL_SIZE = "columns=";
    protected final String SIZE = "size=";
    protected String editable;
    protected String defaultValue;
    protected String rowSize;
    protected String colSize;
    protected String jcrPath;
    protected String selectorAction;
    protected String selectorClass;
    protected String workspaceField;
    protected String selectorIcon;
    protected String multiValues;
    protected String reference;
    protected String validateType;
    protected String selectorParams;
    protected String name;
    protected String label;
    protected String options;
    protected String visible;
    protected String nodeType;
    protected String mixinTypes;
    protected String onchange;
    protected String groovyScript;
    protected String[] scriptParams;
    protected String type;
    protected String size;

    public DialogFormField(String name, String label, String[] arguments) {
        HashMap<String, String> parsedArguments = this.parseArguments(arguments);
        this.editable = parsedArguments.get("editable=");
        this.defaultValue = parsedArguments.get("defaultValues=");
        this.rowSize = parsedArguments.get("rows=");
        this.colSize = parsedArguments.get("columns=");
        this.jcrPath = parsedArguments.get("jcrPath=");
        this.selectorAction = parsedArguments.get("selectorAction=");
        this.selectorClass = parsedArguments.get("selectorClass=");
        this.workspaceField = parsedArguments.get("workspaceField=");
        this.selectorIcon = parsedArguments.get("selectorIcon=");
        this.multiValues = parsedArguments.get("multiValues=");
        this.reference = parsedArguments.get("reference=");
        this.validateType = parsedArguments.get("validate=");
        this.selectorParams = parsedArguments.get("selectorParams=");
        this.options = parsedArguments.get("options=");
        this.visible = parsedArguments.get("visible=");
        this.nodeType = parsedArguments.get("nodetype=");
        this.mixinTypes = parsedArguments.get("mixintype=");
        this.onchange = parsedArguments.get("onchange=");
        this.groovyScript = parsedArguments.get("script=");
        this.type = parsedArguments.get("type=");
        this.size = parsedArguments.get("size=");
        String scriptParam = parsedArguments.get("scriptParams=");
        if (scriptParam != null) {
            this.scriptParams = scriptParam.split(",");
        }
        this.name = name;
        this.label = label;
    }

    public abstract <T extends UIFormInputBase> T createUIFormInput() throws Exception;

    public JcrInputProperty createJcrInputProperty() {
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(this.jcrPath);
        return inputProperty;
    }

    public String getEditable() {
        return this.editable;
    }

    public void setEditable(String editable) {
        this.editable = editable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(String rowSize) {
        this.rowSize = rowSize;
    }

    public String getColSize() {
        return this.colSize;
    }

    public void setColSize(String colSize) {
        this.colSize = colSize;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    public String getSelectorAction() {
        return this.selectorAction;
    }

    public void setSelectorAction(String selectorAction) {
        this.selectorAction = selectorAction;
    }

    public String getSelectorClass() {
        return this.selectorClass;
    }

    public void setSelectorClass(String selectorClass) {
        this.selectorClass = selectorClass;
    }

    public String getWorkspaceField() {
        return this.workspaceField;
    }

    public void setWorkspaceField(String workspaceField) {
        this.workspaceField = workspaceField;
    }

    public String getSelectorIcon() {
        return this.selectorIcon;
    }

    public void setSelectorIcon(String selectorIcon) {
        this.selectorIcon = selectorIcon;
    }

    public String getMultiValues() {
        return this.multiValues;
    }

    public void setMultiValues(String multiValues) {
        this.multiValues = multiValues;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReferenceType(String reference) {
        this.reference = reference;
    }

    public String getValidateType() {
        return this.validateType;
    }

    public void setValidateType(String validateType) {
        this.validateType = validateType;
    }

    public String[] getSelectorParams() {
        if (this.selectorParams != null) {
            return this.selectorParams.split(",");
        }
        return null;
    }

    public String getSelectorParam() {
        return this.selectorParams;
    }

    public void setSelectorParam(String param) {
        this.selectorParams = param;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getMixinTypes() {
        return this.mixinTypes;
    }

    public void setMixinTypes(String mixinTypes) {
        this.mixinTypes = mixinTypes;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    public String[] getScriptParams() {
        return this.scriptParams;
    }

    public void setScriptParams(String[] scriptParams) {
        this.scriptParams = scriptParams;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public boolean isMultiValues() {
        return "true".equalsIgnoreCase(this.multiValues);
    }

    public boolean isReference() {
        return "true".equalsIgnoreCase(this.reference);
    }

    public boolean isEditable() {
        return !"false".equalsIgnoreCase(this.editable);
    }

    public boolean isEditableIfNull() {
        return "if-null".equalsIgnoreCase(this.editable);
    }

    public boolean isVisibleIfNotNull() {
        return "if-not-null".equals(this.visible);
    }

    private HashMap<String, String> parseArguments(String[] arguments) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String argument : arguments) {
            String value = null;
            if (argument.indexOf("=") <= 0) {
                value = argument;
                map.put("defaultValues=", value);
                continue;
            }
            value = argument.substring(argument.indexOf("=") + 1);
            if (argument.startsWith("jcrPath=")) {
                map.put("jcrPath=", value);
                continue;
            }
            if (argument.startsWith("editable=")) {
                map.put("editable=", value);
                continue;
            }
            if (argument.startsWith("selectorAction=")) {
                map.put("selectorAction=", value);
                continue;
            }
            if (argument.startsWith("selectorClass=")) {
                map.put("selectorClass=", value);
                continue;
            }
            if (argument.startsWith("multiValues=")) {
                map.put("multiValues=", value);
                continue;
            }
            if (argument.startsWith("selectorIcon=")) {
                map.put("selectorIcon=", value);
                continue;
            }
            if (argument.startsWith("selectorParams=")) {
                map.put("selectorParams=", value);
                continue;
            }
            if (argument.startsWith("workspaceField=")) {
                map.put("workspaceField=", value);
                continue;
            }
            if (argument.startsWith("validate=")) {
                map.put("validate=", value);
                continue;
            }
            if (argument.startsWith("reference=")) {
                map.put("reference=", value);
                continue;
            }
            if (argument.startsWith("defaultValues=")) {
                map.put("defaultValues=", value);
                continue;
            }
            if (argument.startsWith("rows=")) {
                map.put("rows=", value);
                continue;
            }
            if (argument.startsWith("columns=")) {
                map.put("columns=", value);
                continue;
            }
            if (argument.startsWith("options=")) {
                map.put("options=", value);
                continue;
            }
            if (argument.startsWith("script=")) {
                map.put("script=", value);
                continue;
            }
            if (argument.startsWith("scriptParams=")) {
                map.put("scriptParams=", value);
                continue;
            }
            if (argument.startsWith("visible=")) {
                map.put("visible=", value);
                continue;
            }
            if (argument.startsWith("type=")) {
                map.put("type=", value);
                continue;
            }
            if (argument.startsWith("onchange=")) {
                map.put("onchange=", value);
                continue;
            }
            if (argument.startsWith("mixintype=")) {
                map.put("mixintype=", value);
                continue;
            }
            if (argument.startsWith("nodetype=")) {
                map.put("nodetype=", value);
                continue;
            }
            if (argument.startsWith("size=")) {
                map.put("size=", value);
                continue;
            }
            map.put("defaultValues=", argument);
        }
        return map;
    }
}

