/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.MarkupFragment;
import org.exoplatform.services.portletcache.PortletRenderContext;
import org.exoplatform.services.portletcache.PortletRenderer;
import org.exoplatform.services.portletcache.WindowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortletFutureCache
extends FutureCache<WindowKey, MarkupFragment, PortletRenderContext> {
    private final ConcurrentHashMap<WindowKey, MarkupFragment> entries;
    private final Log log;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int cleanupCache;
    private ScheduledFuture<?> scheduled;

    PortletFutureCache(Log log, int cleanupCache) {
        super((Loader)new PortletRenderer(log));
        this.log = log;
        this.entries = new ConcurrentHashMap();
        this.cleanupCache = PortletFutureCache.preventWrongCleanupCacheValue(cleanupCache);
        this.scheduled = null;
    }

    private static int preventWrongCleanupCacheValue(int value) {
        return value < 0 ? 300 : value;
    }

    public int getCleanupCache() {
        return this.cleanupCache;
    }

    public void updateCleanupCache(int cleanupCache) {
        this.cleanupCache = cleanupCache;
        if (this.scheduled != null) {
            this.stop();
            this.start();
        }
    }

    protected MarkupFragment get(WindowKey key) {
        MarkupFragment value = this.entries.get(key);
        if (value != null) {
            if (value.expirationTimeMillis > System.currentTimeMillis()) {
                return value;
            }
            this.entries.remove(key);
            return null;
        }
        return null;
    }

    protected void put(WindowKey key, MarkupFragment value) {
        if (value.expirationTimeMillis > System.currentTimeMillis()) {
            this.entries.put(key, value);
        }
    }

    public void start() {
        if (this.scheduled == null) {
            this.log.debug((Object)("Starting cache cleaner with a period of " + this.cleanupCache + " seconds"));
            scheduler.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    long now = System.currentTimeMillis();
                    Iterator i = PortletFutureCache.this.entries.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (((MarkupFragment)entry.getValue()).expirationTimeMillis <= now) continue;
                        PortletFutureCache.this.log.trace((Object)("Removing expired entry " + ((WindowKey)entry.getKey()).getWindowId()));
                        i.remove();
                    }
                }
            }, this.cleanupCache, this.cleanupCache, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.scheduled != null) {
            this.log.debug((Object)"Stopping cache cleaner");
            this.scheduled.cancel(false);
            this.scheduled = null;
        }
    }
}

