/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.SerializablePageList;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormGrid;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormPageIterator;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.form.validator.Validator;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.UIPermissionSelector;
import org.exoplatform.webui.organization.UISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/organization/webui/component/UIListPermissionSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={DeleteActionListener.class}, confirm="UIAccessGroup.deleteAccessGroup"), @EventConfig(phase=Event.Phase.DECODE, listeners={UISelector.SelectMembershipActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangePublicModeActionListener.class})})
@Serialized
public class UIListPermissionSelector
extends UISelector<String[]> {
    private boolean publicMode_ = false;

    public UIListPermissionSelector() throws Exception {
        UIFormCheckBoxInput uiPublicMode = new UIFormCheckBoxInput("publicMode", null, (Object)false);
        this.addChild((UIComponent)uiPublicMode);
        UIFormGrid uiGrid = (UIFormGrid)this.addChild(UIFormGrid.class, null, "PermissionGrid");
        uiGrid.setLabel("UIListPermissionSelector");
        uiGrid.configure("expression", new String[]{"groupId", "membership"}, new String[]{"Delete"});
        UIFormPageIterator uiIterator = (UIFormPageIterator)uiGrid.getUIPageIterator();
        uiIterator.setPageList((PageList)new SerializablePageList(UserACL.Permission.class, Collections.emptyList(), 10));
        this.addChild((UIComponent)uiIterator);
        uiIterator.setRendered(false);
        UIFormPopupWindow uiPopup = (UIFormPopupWindow)this.addChild(UIFormPopupWindow.class, null, null);
        uiPopup.setWindowSize(540, 0);
        UIGroupMembershipSelector uiMembershipSelector = (UIGroupMembershipSelector)this.createUIComponent(UIGroupMembershipSelector.class, null, null);
        uiMembershipSelector.setId("ListPermissionSelector");
        ((UITree)uiMembershipSelector.getChild(UITree.class)).setId("TreeListPermissionSelector");
        ((UIBreadcumbs)uiMembershipSelector.getChild(UIBreadcumbs.class)).setId("BreadcumbsListPermissionSelector");
        uiPopup.setUIComponent((UIComponent)uiMembershipSelector);
    }

    public void configure(String iname, String bfield) {
        this.setName(iname);
        this.setId(iname);
        this.setBindingField(bfield);
        UIFormCheckBoxInput uiPublicMode = (UIFormCheckBoxInput)this.getChild(UIFormCheckBoxInput.class);
        uiPublicMode.setOnChange("ChangePublicMode", iname);
        UIFormPopupWindow uiPopup = (UIFormPopupWindow)this.getChild(UIFormPopupWindow.class);
        uiPopup.setId(iname + "Popup");
    }

    private boolean existsPermission(List<?> list, UserACL.Permission permission) throws Exception {
        for (Object ele : list) {
            UserACL.Permission per = (UserACL.Permission)ele;
            if (!per.getExpression().equals(permission.getExpression())) continue;
            return true;
        }
        return false;
    }

    public void clearGroups() throws Exception {
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        uiIterator.setPageList((PageList)new SerializablePageList(UserACL.Permission.class, new ArrayList(), 10));
    }

    public String[] getValue() throws Exception {
        if (this.publicMode_) {
            return new String[]{"Everyone"};
        }
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        List values = uiIterator.getPageList().getAll();
        String[] expPermissions = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            UserACL.Permission permission = (UserACL.Permission)values.get(i);
            expPermissions[i] = permission.getExpression();
        }
        return expPermissions;
    }

    public UIListPermissionSelector setValue(String[] permissions) throws Exception {
        ArrayList<UserACL.Permission> list = new ArrayList<UserACL.Permission>();
        this.setPublicMode(false);
        for (String exp : permissions) {
            if ("Everyone".equals(exp)) {
                UIFormGrid uiGrid = (UIFormGrid)this.getChild(UIFormGrid.class);
                uiGrid.setRendered(false);
                this.setPublicMode(true);
                break;
            }
            if (exp.trim().length() < 1) continue;
            UserACL.Permission permission = new UserACL.Permission();
            permission.setPermissionExpression(exp);
            if (this.existsPermission(list, permission)) continue;
            list.add(permission);
        }
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        uiIterator.setPageList((PageList)new SerializablePageList(UserACL.Permission.class, list, 10));
        return this;
    }

    public void removePermission(String exp) throws Exception {
        ArrayList list = new ArrayList();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        list.addAll(uiIterator.getPageList().getAll());
        for (Object ele : list) {
            UserACL.Permission permission = (UserACL.Permission)ele;
            if (!permission.getExpression().equals(exp)) continue;
            list.remove(ele);
            break;
        }
        uiIterator.setPageList((PageList)new SerializablePageList(UserACL.Permission.class, list, 10));
    }

    @Override
    public void setMembership(String groupId, String membershipType) throws Exception {
        if (groupId.trim().length() < 1 || membershipType.trim().length() < 1) {
            return;
        }
        UserACL.Permission permission = new UserACL.Permission();
        permission.setExpression(membershipType + ":" + groupId);
        permission.setGroupId(groupId);
        permission.setMembership(membershipType);
        ArrayList<UserACL.Permission> list = new ArrayList<UserACL.Permission>();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        list.addAll(uiIterator.getPageList().getAll());
        if (this.existsPermission(list, permission)) {
            return;
        }
        list.add(permission);
        uiIterator.setPageList((PageList)new SerializablePageList(UserACL.Permission.class, list, 10));
    }

    public Class<String[]> getTypeValue() {
        return String[].class;
    }

    public String getLabel(String id) throws Exception {
        String label = null;
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String key = "UIListPermissionSelector.label." + id;
        try {
            label = res.getString(key);
        }
        catch (MissingResourceException e) {
            System.err.println("\nkey: " + key);
        }
        return label;
    }

    public boolean isPublicMode() {
        return this.publicMode_;
    }

    public void setPublicMode(boolean mode) throws Exception {
        this.publicMode_ = mode;
        UIFormCheckBoxInput uiPublicMode = (UIFormCheckBoxInput)this.getChildById("publicMode");
        uiPublicMode.setChecked(this.publicMode_);
        UIFormGrid uiGrid = (UIFormGrid)this.getChild(UIFormGrid.class);
        uiGrid.setRendered(!this.publicMode_);
        if (this.publicMode_) {
            uiGrid.getUIPageIterator().setPageList((PageList)new SerializablePageList(UserACL.Permission.class, new ArrayList(), 10));
        }
    }

    public static class EmptyIteratorValidator
    implements Validator,
    Serializable {
        public void validate(UIFormInput uiInput) throws Exception {
            UIListPermissionSelector uiInputContainer = (UIListPermissionSelector)uiInput;
            if (uiInputContainer.isPublicMode()) {
                return;
            }
            UIFormPageIterator uiInputIterator = (UIFormPageIterator)uiInputContainer.findFirstComponentOfType(UIFormPageIterator.class);
            if (uiInputIterator.getAvailable() < 1) {
                Object[] args = new String[]{"UITabPane.title.UIListPermissionSelector"};
                throw new MessageException(new ApplicationMessage("EmptyIteratorValidator.msg.empty", args, 2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePublicModeActionListener
    extends EventListener<UIListPermissionSelector> {
        public void execute(Event<UIListPermissionSelector> event) throws Exception {
            UIListPermissionSelector uicom = (UIListPermissionSelector)((Object)event.getSource());
            UIFormCheckBoxInput uiPublicModeInput = (UIFormCheckBoxInput)uicom.getChildById("publicMode");
            uicom.setPublicMode(uiPublicModeInput.isChecked());
            uicom.setRendered(true);
            UIForm uiForm = (UIForm)uicom.getAncestorOfType(UIForm.class);
            UIPermissionSelector uiPermission = (UIPermissionSelector)uiForm.findFirstComponentOfType(UIPermissionSelector.class);
            if (uiPermission != null) {
                uiPermission.setRendered(false);
            }
            uiForm.broadcast(event, event.getExecutionPhase());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIListPermissionSelector> {
        public void execute(Event<UIListPermissionSelector> event) throws Exception {
            int currentPage;
            String permission = event.getRequestContext().getRequestParameter("objectId");
            UIListPermissionSelector uiPermissions = (UIListPermissionSelector)((Object)event.getSource());
            UIPageIterator pageIterator = ((UIFormGrid)uiPermissions.getChild(UIFormGrid.class)).getUIPageIterator();
            uiPermissions.removePermission(permission);
            UIContainer uiParent = (UIContainer)uiPermissions.getParent();
            uiParent.setRenderedChild(UIListPermissionSelector.class);
            UIForm uiForm = (UIForm)uiPermissions.getAncestorOfType(UIForm.class);
            uiForm.broadcast(event, event.getExecutionPhase());
            for (currentPage = pageIterator.getCurrentPage(); currentPage > pageIterator.getAvailablePage(); --currentPage) {
            }
            pageIterator.setCurrentPage(currentPage);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

