/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.portal.application.ApplicationStatistic;
import org.exoplatform.portal.application.ApplicationStatisticService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletStatisticLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final String ATTRIBUTE_NAME = "AppStatistic";

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        app.setAttribute(ATTRIBUTE_NAME, (Object)System.currentTimeMillis());
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) throws Exception {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        ApplicationStatisticService service = (ApplicationStatisticService)app.getApplicationServiceContainer().getComponentInstanceOfType(ApplicationStatisticService.class);
        ApplicationStatistic appStatistic = service.getApplicationStatistic(app.getApplicationId());
        long startTime = Long.valueOf(app.getAttribute(ATTRIBUTE_NAME).toString());
        appStatistic.logTime(System.currentTimeMillis() - startTime);
    }

    public void onDestroy(Application app) {
    }
}

