/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OpenOfficeDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.oasis.opendocument.database", "application/vnd.oasis.opendocument.formula", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        String string;
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                String string2 = "";
                return string2;
            }
            while (!ze.getName().equals("content.xml")) {
                ze = zis.getNextEntry();
            }
            OpenOfficeContentHandler contentHandler = new OpenOfficeContentHandler();
            xmlReader.setContentHandler(contentHandler);
            try {
                xmlReader.parse(new InputSource(zis));
            }
            finally {
                try {
                    zis.close();
                }
                catch (IOException e) {}
            }
            string = contentHandler.getContent();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return string;
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            while (!ze.getName().equals("meta.xml")) {
                ze = zis.getNextEntry();
            }
            OpenOfficeMetaHandler metaHandler = new OpenOfficeMetaHandler();
            xmlReader.setContentHandler(metaHandler);
            try {
                xmlReader.parse(new InputSource(zis));
            }
            finally {
                zis.close();
            }
            Properties properties = metaHandler.getProperties();
            return properties;
        }
        catch (ParserConfigurationException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class OpenOfficeMetaHandler
    extends DefaultHandler {
        private Properties props = new Properties();
        private QName curPropertyName;
        private StringBuilder curPropertyValue = new StringBuilder();

        public Properties getProperties() {
            return this.props;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("dc:")) {
                this.curPropertyName = new QName("http://purl.org/dc/elements/1.1/", rawName.substring(3));
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.curPropertyName != null) {
                this.curPropertyValue.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.curPropertyName != null) {
                this.props.put(this.curPropertyName, this.curPropertyValue.toString());
                this.curPropertyValue = new StringBuilder();
                this.curPropertyName = null;
            }
        }
    }

    private class OpenOfficeContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;

        public String getContent() {
            return this.content.toString();
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("text:")) {
                this.appendChar = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendChar) {
                this.content.append(ch, start, length).append(" ");
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
        }
    }
}

