/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.ItemDataCopyIgnoredVisitor;
import org.exoplatform.services.jcr.impl.dataflow.AbstractItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemDataRestoreVisitor
extends AbstractItemDataCopyVisitor {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDataRestoreVisitor");
    protected final boolean removeExisting;
    protected final Stack<NodeDataContext> parents = new Stack();
    protected final NodeData context;
    protected final NodeData history;
    protected final InternalQName destName;
    protected NodeData restored;
    protected final SessionImpl userSession;
    protected final SessionChangesLog changes;
    protected final SessionChangesLog delegatedChanges;
    private NodeTypeDataManager nodeTypeDataManager;

    ItemDataRestoreVisitor(NodeData context, InternalQName restoringName, NodeData history, SessionImpl userSession, boolean removeExisting) throws RepositoryException {
        this(context, restoringName, history, userSession, removeExisting, null);
    }

    ItemDataRestoreVisitor(NodeData context, InternalQName destName, NodeData history, SessionImpl userSession, boolean removeExisting, SessionChangesLog delegatedChanges) throws RepositoryException {
        super(userSession.getTransientNodesManager().getTransactManager());
        this.userSession = userSession;
        this.changes = new SessionChangesLog(userSession.getId());
        this.context = context;
        this.destName = destName;
        this.history = history;
        this.parents.push(new NodeDataContext(context));
        this.removeExisting = removeExisting;
        this.nodeTypeDataManager = userSession.getWorkspace().getNodeTypesHolder();
        this.delegatedChanges = delegatedChanges;
    }

    private NodeData currentNode() {
        return this.parents.peek().getNode();
    }

    private NodeData pushCurrent(NodeData node) {
        return this.parents.push(new NodeDataContext(node)).getNode();
    }

    private ItemData findDelegated(String identifier) {
        if (this.delegatedChanges != null) {
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getIdentifier().equals(identifier)) continue;
                return state.getData();
            }
        }
        return null;
    }

    private ItemData findDelegated(QPath path) {
        if (this.delegatedChanges != null) {
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getQPath().equals(path)) continue;
                return state.getData();
            }
        }
        return null;
    }

    private void deleteDelegated(QPath path) {
        if (this.delegatedChanges != null) {
            ArrayList<ItemState> removed = new ArrayList<ItemState>();
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getQPath().equals(path) && !state.getData().getQPath().isDescendantOf(path)) continue;
                removed.add(state);
            }
            for (ItemState state : removed) {
                this.delegatedChanges.remove(state.getData().getQPath());
            }
        }
    }

    protected void initRestoreRoot(NodeData parentData, InternalQName name, NodeData frozen) throws RepositoryException {
        NodeData existing;
        String fidentifier;
        QPath nodePath;
        block18: {
            nodePath = QPath.makeChildPath(parentData.getQPath(), name);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Restore: " + nodePath.getAsString() + ", removeExisting=" + this.removeExisting));
            }
            PropertyData frozenIdentifier = (PropertyData)this.dataManager.getItemData(frozen, new QPathEntry(Constants.JCR_FROZENUUID, 1), ItemType.PROPERTY);
            fidentifier = null;
            existing = null;
            try {
                fidentifier = new String(frozenIdentifier.getValues().get(0).getAsByteArray());
                NodeData sameIdentifierNodeRestored = (NodeData)this.findDelegated(fidentifier);
                if (sameIdentifierNodeRestored != null) {
                    this.deleteDelegated(sameIdentifierNodeRestored.getQPath());
                    break block18;
                }
                NodeData sameIdentifierNode = (NodeData)this.dataManager.getItemData(fidentifier);
                if (sameIdentifierNode == null) break block18;
                QPath sameIdentifierPath = sameIdentifierNode.getQPath();
                if (sameIdentifierPath.makeParentPath().equals(nodePath.makeParentPath()) && sameIdentifierPath.getName().equals((Object)nodePath.getName())) {
                    if (sameIdentifierPath.getIndex() != nodePath.getIndex()) {
                        nodePath = QPath.makeChildPath(parentData.getQPath(), name, sameIdentifierPath.getIndex());
                    }
                    existing = sameIdentifierNode;
                    ItemDataRestoreVisitor.RemoveVisitor removeVisitor = new ItemDataRestoreVisitor.RemoveVisitor();
                    removeVisitor.visit(existing);
                    this.changes.addAll(removeVisitor.getRemovedStates());
                    break block18;
                }
                if (sameIdentifierPath.isDescendantOf(nodePath)) break block18;
                if (this.removeExisting) {
                    final QPath restorePath = nodePath;
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class RemoveVisitor
                    extends ItemDataRemoveVisitor {
                        RemoveVisitor() throws RepositoryException {
                            super(ItemDataRestoreVisitor.this.userSession.getTransientNodesManager(), null, ItemDataRestoreVisitor.this.nodeTypeDataManager, ItemDataRestoreVisitor.this.userSession.getAccessManager(), ItemDataRestoreVisitor.this.userSession.getUserState());
                        }

                        @Override
                        protected boolean isRemoveDescendant(ItemData item) throws RepositoryException {
                            return item.getQPath().isDescendantOf(this.removedRoot.getQPath()) || item.getQPath().isDescendantOf(restorePath);
                        }
                    }
                    RemoveVisitor removeVisitor = new RemoveVisitor();
                    removeVisitor.visit(sameIdentifierNode);
                    this.changes.addAll(removeVisitor.getRemovedStates());
                    break block18;
                }
                throw new ItemExistsException("Item with the same UUID as restored node " + nodePath.getAsString() + " already exists and removeExisting=false. Existed " + this.userSession.getLocationFactory().createJCRPath(sameIdentifierPath).getAsString(false) + " " + sameIdentifierNode.getIdentifier());
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:frozenUuid, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenIdentifier.getQPath()).getAsString(false), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:frozenUuid, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenIdentifier.getQPath()).getAsString(false), (Throwable)e);
            }
        }
        PropertyData frozenPrimaryType = (PropertyData)this.dataManager.getItemData(frozen, new QPathEntry(Constants.JCR_FROZENPRIMARYTYPE, 0), ItemType.PROPERTY);
        PropertyData frozenMixinTypes = (PropertyData)this.dataManager.getItemData(frozen, new QPathEntry(Constants.JCR_FROZENMIXINTYPES, 0), ItemType.PROPERTY);
        InternalQName[] mixins = null;
        if (frozenMixinTypes != null) {
            try {
                List<ValueData> mvs = frozenMixinTypes.getValues();
                mixins = new InternalQName[mvs.size()];
                for (int i = 0; i < mvs.size(); ++i) {
                    ValueData mvd = mvs.get(i);
                    mixins[i] = InternalQName.parse(new String(mvd.getAsByteArray()));
                }
            }
            catch (IllegalNameException e) {
                throw new RepositoryException("jcr:frozenMixinTypes, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenMixinTypes.getQPath()).getAsString(false), (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:frozenMixinTypes, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenMixinTypes.getQPath()).getAsString(false), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:frozenMixinTypes, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenMixinTypes.getQPath()).getAsString(false), (Throwable)e);
            }
        }
        InternalQName ptName = null;
        try {
            ptName = InternalQName.parse(new String(frozenPrimaryType.getValues().get(0).getAsByteArray()));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException("jcr:frozenPrimaryType, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenPrimaryType.getQPath()).getAsString(false), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("jcr:frozenPrimaryType, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenPrimaryType.getQPath()).getAsString(false), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("jcr:frozenPrimaryType, error of data read " + this.userSession.getLocationFactory().createJCRPath(frozenPrimaryType.getQPath()).getAsString(false), (Throwable)e);
        }
        TransientNodeData restoredData = new TransientNodeData(nodePath, fidentifier, existing != null ? existing.getPersistedVersion() : -1, ptName, mixins == null ? new InternalQName[]{} : mixins, 0, parentData.getIdentifier(), parentData.getACL());
        this.changes.add(ItemState.createAddedState(restoredData));
        this.pushCurrent(restoredData);
    }

    protected void entering(NodeData frozen, int level) throws RepositoryException {
        InternalQName qname;
        if (frozen == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Visit node " + frozen.getQPath().getAsString() + ", HAS NULL FROZEN NODE"));
        }
        if ((qname = frozen.getQPath().getName()).equals((Object)Constants.JCR_FROZENNODE) && level == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("jcr:frozenNode " + frozen.getQPath().getAsString()));
            }
            this.initRestoreRoot(this.currentNode(), this.destName, frozen);
            this.restored = this.currentNode();
        } else if (this.nodeTypeDataManager.isNodeType(Constants.NT_VERSIONEDCHILD, frozen.getPrimaryTypeName())) {
            QPath cvhpPropPath = QPath.makeChildPath(frozen.getQPath(), Constants.JCR_CHILDVERSIONHISTORY);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Versioned child node " + cvhpPropPath.getAsString()));
            }
            VersionHistoryDataHelper childHistory = null;
            try {
                String vhIdentifier = new String(((PropertyData)this.dataManager.getItemData(frozen, new QPathEntry(Constants.JCR_CHILDVERSIONHISTORY, 0), ItemType.PROPERTY)).getValues().get(0).getAsByteArray());
                NodeData cHistory = null;
                cHistory = (NodeData)this.dataManager.getItemData(vhIdentifier);
                if (cHistory == null) {
                    throw new RepositoryException("Version history is not found with uuid " + vhIdentifier);
                }
                childHistory = new VersionHistoryDataHelper(cHistory, this.dataManager, this.nodeTypeDataManager);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + this.userSession.getLocationFactory().createJCRPath(cvhpPropPath).getAsString(false), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + this.userSession.getLocationFactory().createJCRPath(cvhpPropPath).getAsString(false), (Throwable)e);
            }
            String versionableIdentifier = null;
            try {
                versionableIdentifier = new String(((PropertyData)this.dataManager.getItemData(childHistory, new QPathEntry(Constants.JCR_VERSIONABLEUUID, 0), ItemType.PROPERTY)).getValues().get(0).getAsByteArray());
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + this.userSession.getLocationFactory().createJCRPath(cvhpPropPath).getAsString(false), (Throwable)e);
            }
            NodeData versionable = (NodeData)this.dataManager.getItemData(versionableIdentifier);
            if (versionable != null) {
                if (!this.removeExisting) {
                    throw new ItemExistsException("Item with the same UUID " + versionableIdentifier + " as versionable child node " + this.userSession.getLocationFactory().createJCRPath(versionable.getQPath()).getAsString(false) + " already exists and removeExisting=false");
                }
            } else {
                NodeData lastVersionData = childHistory.getLastVersionData();
                NodeData cvFrozen = (NodeData)this.dataManager.getItemData(lastVersionData, new QPathEntry(Constants.JCR_FROZENNODE, 1), ItemType.NODE);
                ItemDataRestoreVisitor restoreVisitor = new ItemDataRestoreVisitor(this.currentNode(), qname, childHistory, this.userSession, this.removeExisting, this.changes);
                cvFrozen.accept(restoreVisitor);
                this.changes.addAll(restoreVisitor.getRestoreChanges().getAllStates());
            }
            this.pushCurrent(null);
        } else if (this.currentNode() != null) {
            int action = this.nodeTypeDataManager.getChildNodeDefinition(qname, this.currentNode().getPrimaryTypeName(), this.currentNode().getMixinTypeNames()).getOnParentVersion();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Stored node " + frozen.getQPath().getAsString() + ", " + OnParentVersionAction.nameFromValue((int)action)));
            }
            if (action == 1 || action == 2) {
                QPath restoredPath = QPath.makeChildPath(this.currentNode().getQPath(), frozen.getQPath().getName(), frozen.getQPath().getIndex());
                String jcrUuid = null;
                NodeData existing = null;
                if (this.nodeTypeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, frozen.getPrimaryTypeName(), frozen.getMixinTypeNames())) {
                    QPath jcrUuidPath = QPath.makeChildPath(frozen.getQPath(), Constants.JCR_UUID);
                    try {
                        jcrUuid = new String(((PropertyData)this.dataManager.getItemData(frozen, new QPathEntry(Constants.JCR_UUID, 0), ItemType.PROPERTY)).getValues().get(0).getAsByteArray());
                    }
                    catch (IOException e) {
                        throw new RepositoryException("jcr:uuid, error of data read " + this.userSession.getLocationFactory().createJCRPath(jcrUuidPath).getAsString(false), (Throwable)e);
                    }
                    existing = (NodeData)this.dataManager.getItemData(jcrUuid);
                } else {
                    existing = (NodeData)this.dataManager.getItemData(this.currentNode(), new QPathEntry(frozen.getQPath().getName(), frozen.getQPath().getIndex()), ItemType.NODE);
                    jcrUuid = existing != null ? existing.getIdentifier() : IdGenerator.generate();
                }
                if (existing != null && !existing.getQPath().isDescendantOf(this.restored.getQPath())) {
                    NodeData existingDelegared = (NodeData)this.findDelegated(existing.getQPath());
                    if (existingDelegared != null) {
                        this.deleteDelegated(existing.getQPath());
                    } else if (this.removeExisting) {
                        RemoveVisitor removeVisitor = new RemoveVisitor();
                        removeVisitor.visit(existing);
                        this.changes.addAll(removeVisitor.getRemovedStates());
                    } else {
                        throw new ItemExistsException("Node with the same UUID as restored child node " + this.userSession.getLocationFactory().createJCRPath(restoredPath).getAsString(false) + " already exists and removeExisting=false. Existed " + this.userSession.getLocationFactory().createJCRPath(existing.getQPath()).getAsString(false) + " " + existing.getIdentifier());
                    }
                }
                TransientNodeData restoredData = new TransientNodeData(restoredPath, jcrUuid, frozen.getPersistedVersion(), frozen.getPrimaryTypeName(), frozen.getMixinTypeNames(), frozen.getOrderNumber(), this.currentNode().getIdentifier(), frozen.getACL());
                this.changes.add(ItemState.createAddedState(restoredData));
                this.pushCurrent(restoredData);
            } else if (action == 3 || action == 4) {
                NodeData existed = (NodeData)this.dataManager.getItemData(this.currentNode(), new QPathEntry(frozen.getQPath().getName(), 0), ItemType.NODE);
                if (existed != null) {
                    ItemDataCopyVisitor copyVisitor = new ItemDataCopyVisitor(this.currentNode(), frozen.getQPath().getName(), this.nodeTypeDataManager, this.userSession.getTransientNodesManager(), true);
                    existed.accept(copyVisitor);
                    this.changes.addAll(copyVisitor.getItemAddStates());
                }
                this.pushCurrent(null);
            }
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (this.currentNode() != null) {
            NodeData frozenParent = (NodeData)this.dataManager.getItemData(property.getParentIdentifier());
            InternalQName qname = property.getQPath().getName();
            if (this.nodeTypeDataManager.isNodeType(Constants.NT_FROZENNODE, frozenParent.getPrimaryTypeName())) {
                if (qname.equals((Object)Constants.JCR_FROZENPRIMARYTYPE)) {
                    qname = Constants.JCR_PRIMARYTYPE;
                } else if (qname.equals((Object)Constants.JCR_FROZENUUID)) {
                    qname = Constants.JCR_UUID;
                } else if (qname.equals((Object)Constants.JCR_FROZENMIXINTYPES)) {
                    qname = Constants.JCR_MIXINTYPES;
                } else if (qname.equals((Object)Constants.JCR_PRIMARYTYPE) || qname.equals((Object)Constants.JCR_UUID) || qname.equals((Object)Constants.JCR_MIXINTYPES)) {
                    return;
                }
            }
            int action = this.nodeTypeDataManager.getPropertyDefinitions(qname, this.currentNode().getPrimaryTypeName(), this.currentNode().getMixinTypeNames()).getAnyDefinition().getOnParentVersion();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Visit property " + property.getQPath().getAsString() + " " + this.currentNode().getQPath().getAsString() + " " + OnParentVersionAction.nameFromValue((int)action)));
            }
            if (action == 1 || action == 2 || action == 3 || action == 4) {
                TransientPropertyData tagetProperty = null;
                tagetProperty = qname.equals((Object)Constants.JCR_PREDECESSORS) ? TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), property.isMultiValued(), new ArrayList<ValueData>()) : TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), property.isMultiValued(), this.copyValues(property));
                this.changes.add(ItemState.createAddedState(tagetProperty));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Visit property " + property.getQPath().getAsString() + " HAS " + OnParentVersionAction.nameFromValue((int)action) + " action"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Visit property " + property.getQPath().getAsString() + " HAS NULL PARENT. Restore of this property is impossible."));
        }
    }

    protected void leaving(NodeData frozen, int level) throws RepositoryException {
        InternalQName qname = frozen.getQPath().getName();
        if (qname.equals((Object)Constants.JCR_FROZENNODE) && level == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("leaving jcr:frozenNode " + frozen.getQPath().getAsString()));
            }
            TransientPropertyData baseVersion = TransientPropertyData.createPropertyData(this.restored, Constants.JCR_BASEVERSION, 9, false, new TransientValueData(frozen.getParentIdentifier()));
            TransientPropertyData isCheckedOut = TransientPropertyData.createPropertyData(this.restored, Constants.JCR_ISCHECKEDOUT, 6, false, new TransientValueData(false));
            NodeData existing = (NodeData)this.dataManager.getItemData(this.restored.getIdentifier());
            if (existing != null && !existing.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
                ItemDataCopyIgnoredVisitor copyIgnoredVisitor = new ItemDataCopyIgnoredVisitor((NodeData)this.dataManager.getItemData(this.restored.getParentIdentifier()), this.restored.getQPath().getName(), this.nodeTypeDataManager, this.userSession.getTransientNodesManager(), this.changes);
                existing.accept(copyIgnoredVisitor);
                this.changes.addAll(copyIgnoredVisitor.getItemAddStates());
            }
            this.changes.add(ItemState.createAddedState(baseVersion));
            this.changes.add(ItemState.createAddedState(isCheckedOut));
        }
        if (this.parents.size() <= 0) {
            this.log.error((Object)"Empty parents stack");
        }
        this.parents.pop();
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    public SessionChangesLog getRestoreChanges() {
        return this.changes;
    }

    public NodeData getRestoreRoot() {
        return this.restored;
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor() throws RepositoryException {
            super(ItemDataRestoreVisitor.this.userSession.getTransientNodesManager(), null, ItemDataRestoreVisitor.this.nodeTypeDataManager, ItemDataRestoreVisitor.this.userSession.getAccessManager(), ItemDataRestoreVisitor.this.userSession.getUserState());
        }

        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }

    protected class NodeDataContext {
        private final NodeData node;
        private final boolean existing;

        protected NodeDataContext(NodeData node) {
            this.node = node;
            this.existing = false;
        }

        protected NodeDataContext(NodeData node, boolean existing) {
            this.node = node;
            this.existing = existing;
        }

        protected NodeData getNode() {
            return this.node;
        }

        public boolean isExisting() {
            return this.existing;
        }
    }
}

