/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.impl.store.ldap.SimpleLDAPIdentityObjectTypeConfiguration;
import org.picketlink.idm.impl.types.SimpleIdentityObjectType;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLDAPIdentityStoreConfiguration
implements LDAPIdentityStoreConfiguration,
Serializable {
    private final IdentityStoreConfigurationMetaData configurationMetaData;
    private final String providerURL;
    private final String adminDN;
    private final String adminPassword;
    private final String authenticationMethod;
    private final int searchTimeLimit;
    private final Map<String, LDAPIdentityObjectTypeConfiguration> typesConfiguration;
    private final Map<String, String> customJNDIConnectionParameters;
    private final Map<String, String> customSystemProperties;
    private final String externalJNDIContext;
    private final String membershipToRelationshipTypeMapping;
    private final boolean supportNamedRelationships;
    private final String[] relationshipNamesCtxDNs;
    private final String relationshipNameSearchFilter;
    private final String relationshipNameSearchScope;
    private final Map<String, String[]> relationshipNameCreateEntryAttributeValues;
    private final String relationshipNameAttributeName;
    private final String namedRelationshipSearchFilter;
    private final Map<String, String[]> namedRelationshipCreateEntryAttributeValues;
    private final String namedRelationshipNameAttributeName;
    private final String namedRelationshipMemberAttributeName;
    private final boolean sortExtensionSupported;
    private final boolean pagedExtensionSupported;
    private final int pagedExtensionSize;
    private final boolean createMissingContexts;
    public static final String PROVIDER_URL = "providerURL";
    public static final String ADMIN_DN = "adminDN";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String ADMIN_PASSWORD = "adminPassword";
    public static final String SEARCH_TIME_LIMIT = "searchTimeLimit";
    public static final int SEARCH_TIME_LIMIT_DEFAULT = 10000;
    public static final String CUSTOM_JNDI_CONNECTION_PARAMETERS = "customJNDIConnectionParameters";
    public static final String CUSTOM_SYSTEM_PROPERTIES = "customSystemProperties";
    public static final String EXTERNAL_JNDI_CONTEXT = "externalJNDIContext";
    public static final String MEMBERSHIP_TO_RELATIONSHIP_TYPE_MAPPING = "membershipToRelationshipTypeMapping";
    public static final String SUPPORT_NAMED_RELATIONSHIPS = "supportNamedRelationships";
    public static final String RELATIONSHIP_NAMES_CTX_DNS = "relationshipNamesCtxDNs";
    public static final String RELATIONSHIP_NAME_SEARCH_FILTER = "relationshipNameSearchFilter";
    public static final String RELATIONSHIP_NAME_SEARCH_SCOPE = "relationshipNameSearchScope";
    public static final String RELATIONSHOP_NAME_CREATE_ENTRY_ATTRIBUTE_VALUES = "relationshipNameCreateEntryAttributeValues";
    public static final String RELATIONSHIP_NAME_ATTRIBUTE_NAME = "relationshipNameAttributeName";
    public static final String NAMED_RELATIONSHIP_SEARCH_FILTER = "namedRelationshipSearchFilter";
    public static final String NAMED_RELATIONSHIP_CREATE_ENTRY_ATTRIBUTE_VALUES = "namedRelationshipCreateEntryAttributeValues";
    public static final String NAMED_RELATIONSHIP_NAME_ATTRIBUTE_NAME = "namedRelationshipNameAttributeName";
    public static final String NAMED_RELATIONSHIP_MEMBER_ATTRIBUTE_NAME = "namedRelationshipMemberAttributeName";
    public static final String SORT_EXTENSION_SUPPORTED = "sortExtensionSupported";
    public static final String PAGE_EXTENSION_SUPPORTED = "pagedResultsExtensionSupported";
    public static final String PAGE_EXTENSION_SIZE = "pagedResultsExtensionSize";
    public static final int PAGE_EXTENSION_SIZE_DEFAULT = 1000;
    public static final String CREATE_MISSING_CONTEXTS = "createMissingContexts";

    public SimpleLDAPIdentityStoreConfiguration(IdentityStoreConfigurationMetaData storeMD) {
        if (storeMD == null) {
            throw new IllegalArgumentException();
        }
        this.configurationMetaData = storeMD;
        this.providerURL = storeMD.getOptionSingleValue(PROVIDER_URL);
        this.adminDN = storeMD.getOptionSingleValue(ADMIN_DN);
        this.authenticationMethod = storeMD.getOptionSingleValue(AUTHENTICATION_METHOD);
        this.adminPassword = storeMD.getOptionSingleValue(ADMIN_PASSWORD);
        this.externalJNDIContext = storeMD.getOptionSingleValue(EXTERNAL_JNDI_CONTEXT);
        this.membershipToRelationshipTypeMapping = storeMD.getOptionSingleValue(MEMBERSHIP_TO_RELATIONSHIP_TYPE_MAPPING);
        this.relationshipNameSearchFilter = storeMD.getOptionSingleValue(RELATIONSHIP_NAME_SEARCH_FILTER);
        this.relationshipNameSearchScope = storeMD.getOptionSingleValue(RELATIONSHIP_NAME_SEARCH_SCOPE);
        this.relationshipNameAttributeName = storeMD.getOptionSingleValue(RELATIONSHIP_NAME_ATTRIBUTE_NAME);
        this.namedRelationshipSearchFilter = storeMD.getOptionSingleValue(NAMED_RELATIONSHIP_SEARCH_FILTER);
        this.namedRelationshipNameAttributeName = storeMD.getOptionSingleValue(NAMED_RELATIONSHIP_NAME_ATTRIBUTE_NAME);
        this.namedRelationshipMemberAttributeName = storeMD.getOptionSingleValue(NAMED_RELATIONSHIP_MEMBER_ATTRIBUTE_NAME);
        String searchTL = storeMD.getOptionSingleValue(SEARCH_TIME_LIMIT);
        this.searchTimeLimit = searchTL != null ? Integer.valueOf(searchTL) : 10000;
        String supportNamedRelationships = storeMD.getOptionSingleValue(SUPPORT_NAMED_RELATIONSHIPS);
        this.supportNamedRelationships = supportNamedRelationships != null && supportNamedRelationships.equalsIgnoreCase("true");
        String sortExtension = storeMD.getOptionSingleValue(SORT_EXTENSION_SUPPORTED);
        this.sortExtensionSupported = sortExtension == null || !sortExtension.equalsIgnoreCase("false");
        String pagedExtension = storeMD.getOptionSingleValue(PAGE_EXTENSION_SUPPORTED);
        this.pagedExtensionSupported = pagedExtension != null && pagedExtension.equalsIgnoreCase("true");
        String pageSize = storeMD.getOptionSingleValue(PAGE_EXTENSION_SIZE);
        this.pagedExtensionSize = pageSize != null ? Integer.valueOf(pageSize) : 1000;
        String createMissingContexts = storeMD.getOptionSingleValue(CREATE_MISSING_CONTEXTS);
        this.createMissingContexts = createMissingContexts != null && createMissingContexts.equalsIgnoreCase("true");
        HashMap<String, LDAPIdentityObjectTypeConfiguration> types = new HashMap<String, LDAPIdentityObjectTypeConfiguration>();
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : storeMD.getSupportedIdentityTypes()) {
            SimpleLDAPIdentityObjectTypeConfiguration typeConfig = new SimpleLDAPIdentityObjectTypeConfiguration(identityObjectTypeMetaData);
            types.put(identityObjectTypeMetaData.getName(), typeConfig);
        }
        List dns = storeMD.getOption(RELATIONSHIP_NAMES_CTX_DNS);
        this.relationshipNamesCtxDNs = dns != null ? dns.toArray(new String[dns.size()]) : null;
        this.typesConfiguration = types;
        HashMap createNamedRelationshipEntryAttributesMap = new HashMap();
        List createNamedRelationshipAttributes = storeMD.getOption(NAMED_RELATIONSHIP_CREATE_ENTRY_ATTRIBUTE_VALUES);
        if (createNamedRelationshipAttributes != null && createNamedRelationshipAttributes.size() > 0) {
            for (String attribute : createNamedRelationshipAttributes) {
                String[] parts = attribute.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!createNamedRelationshipEntryAttributesMap.containsKey(name)) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(value);
                    createNamedRelationshipEntryAttributesMap.put(name, list);
                    continue;
                }
                ((List)createNamedRelationshipEntryAttributesMap.get(name)).add(value);
            }
            HashMap createEntryAttributesArray = new HashMap();
            for (Map.Entry entry : createNamedRelationshipEntryAttributesMap.entrySet()) {
                createEntryAttributesArray.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            }
            this.namedRelationshipCreateEntryAttributeValues = Collections.unmodifiableMap(createEntryAttributesArray);
        } else {
            this.namedRelationshipCreateEntryAttributeValues = Collections.unmodifiableMap(new HashMap());
        }
        HashMap createRelationshipNameEntryAttributesMap = new HashMap();
        List createRelationshipNameAttributes = storeMD.getOption(RELATIONSHOP_NAME_CREATE_ENTRY_ATTRIBUTE_VALUES);
        if (createRelationshipNameAttributes != null && createRelationshipNameAttributes.size() > 0) {
            for (String attribute : createRelationshipNameAttributes) {
                String[] parts = attribute.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!createRelationshipNameEntryAttributesMap.containsKey(name)) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(value);
                    createRelationshipNameEntryAttributesMap.put(name, list);
                    continue;
                }
                ((List)createRelationshipNameEntryAttributesMap.get(name)).add(value);
            }
            HashMap createEntryAttributesArray = new HashMap();
            for (Map.Entry entry : createRelationshipNameEntryAttributesMap.entrySet()) {
                createEntryAttributesArray.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            }
            this.relationshipNameCreateEntryAttributeValues = Collections.unmodifiableMap(createEntryAttributesArray);
        } else {
            this.relationshipNameCreateEntryAttributeValues = Collections.unmodifiableMap(new HashMap());
        }
        List customJndiParams = storeMD.getOption(CUSTOM_JNDI_CONNECTION_PARAMETERS);
        HashMap<String, String> customJndiParamsMap = new HashMap<String, String>();
        if (customJndiParams != null && customJndiParams.size() > 0) {
            for (String param : customJndiParams) {
                String[] parts = param.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                customJndiParamsMap.put(name, value);
            }
            this.customJNDIConnectionParameters = Collections.unmodifiableMap(customJndiParamsMap);
        } else {
            this.customJNDIConnectionParameters = Collections.unmodifiableMap(new HashMap());
        }
        List customSystemProps = storeMD.getOption(CUSTOM_SYSTEM_PROPERTIES);
        HashMap<String, String> customSystemProperties = new HashMap<String, String>();
        if (customSystemProps != null && customSystemProps.size() > 0) {
            for (String param : customSystemProps) {
                String[] parts = param.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                customSystemProperties.put(name, value);
            }
            this.customSystemProperties = Collections.unmodifiableMap(customSystemProperties);
        } else {
            this.customSystemProperties = Collections.unmodifiableMap(new HashMap());
        }
    }

    @Override
    public String getProviderURL() {
        return this.providerURL;
    }

    @Override
    public String getAdminDN() {
        return this.adminDN;
    }

    @Override
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @Override
    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    @Override
    public LDAPIdentityObjectTypeConfiguration getTypeConfiguration(String typeName) {
        return this.typesConfiguration.get(typeName);
    }

    @Override
    public IdentityObjectType[] getConfiguredTypes() {
        IdentityObjectType[] types = new IdentityObjectType[this.typesConfiguration.size()];
        Object[] names = this.typesConfiguration.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].toString();
            types[i] = new SimpleIdentityObjectType(name);
        }
        return types;
    }

    @Override
    public IdentityStoreConfigurationMetaData getConfigurationMetaData() {
        return this.configurationMetaData;
    }

    @Override
    public Map<String, LDAPIdentityObjectTypeConfiguration> getTypesConfiguration() {
        return this.typesConfiguration;
    }

    @Override
    public Map<String, String> getCustomJNDIConnectionParameters() {
        return this.customJNDIConnectionParameters;
    }

    @Override
    public Map<String, String> getCustomSystemProperties() {
        return this.customSystemProperties;
    }

    @Override
    public String getExternalJNDIContext() {
        return this.externalJNDIContext;
    }

    @Override
    public String getMembershipToRelationshipTypeMapping() {
        return this.membershipToRelationshipTypeMapping;
    }

    @Override
    public boolean isSupportNamedRelationships() {
        return this.supportNamedRelationships;
    }

    @Override
    public String[] getRelationshipNamesCtxDNs() {
        return this.relationshipNamesCtxDNs;
    }

    @Override
    public String getRelationshipNameSearchFilter() {
        return this.relationshipNameSearchFilter;
    }

    @Override
    public String getRelationshipNameSearchScope() {
        return this.relationshipNameSearchScope;
    }

    @Override
    public Map<String, String[]> getRelationshipNameCreateEntryAttributeValues() {
        return this.relationshipNameCreateEntryAttributeValues;
    }

    @Override
    public String getRelationshipNameAttributeName() {
        return this.relationshipNameAttributeName;
    }

    @Override
    public String getNamedRelationshipSearchFilter() {
        return this.namedRelationshipSearchFilter;
    }

    @Override
    public Map<String, String[]> getNamedRelationshipCreateEntryAttributeValues() {
        return this.namedRelationshipCreateEntryAttributeValues;
    }

    @Override
    public String getNamedRelationshipNameAttributeName() {
        return this.namedRelationshipNameAttributeName;
    }

    @Override
    public String getNamedRelationshipMemberAttributeName() {
        return this.namedRelationshipMemberAttributeName;
    }

    @Override
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Override
    public boolean isSortExtensionSupported() {
        return this.sortExtensionSupported;
    }

    @Override
    public boolean isCreateMissingContexts() {
        return this.createMissingContexts;
    }

    @Override
    public boolean isPagedExtensionSupported() {
        return this.pagedExtensionSupported;
    }

    @Override
    public int getPagedExtensionSize() {
        return this.pagedExtensionSize;
    }
}

