/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.statistics;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.statistics.JCRStatisticsManager;
import org.exoplatform.services.jcr.statistics.Statistics;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsJDBCStorageConnection
implements WorkspaceStorageConnection {
    private static final String UPDATE_PROPERTY_DATA_DESCR = "updatePropertyData";
    private static final String UPDATE_NODE_DATA_DESCR = "updateNodeData";
    private static final String ROLLBACK_DESCR = "rollback";
    private static final String RENAME_NODE_DATA_DESCR = "renameNodeData";
    private static final String LIST_CHILD_PROPERTIES_DATA_DESCR = "listChildPropertiesData";
    private static final String IS_OPENED_DESCR = "isOpened";
    private static final String GET_REFERENCES_DATA_DESCR = "getReferencesData";
    private static final String GET_ITEM_DATA_BY_ID_DESCR = "getItemDataById";
    private static final String GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR = "getItemDataByNodeDataNQPathEntry";
    private static final String GET_CHILD_PROPERTIES_DATA_DESCR = "getChildPropertiesData";
    private static final String GET_CHILD_NODES_DATA_DESCR = "getChildNodesData";
    private static final String GET_CHILD_NODES_COUNT_DESCR = "getChildNodesCount";
    private static final String GET_LAST_ORDER_NUMBER_DESCR = "getLastOrderNumber";
    private static final String DELETE_PROPERTY_DATA_DESCR = "deletePropertyData";
    private static final String DELETE_NODE_DATA_DESCR = "deleteNodeData";
    private static final String COMMIT_DESCR = "commit";
    private static final String CLOSE_DESCR = "close";
    private static final String ADD_PROPERTY_DATA_DESCR = "addPropertyData";
    private static final String ADD_NODE_DATA_DESCR = "addNodeData";
    private static final Statistics GLOBAL_STATISTICS = new Statistics(null, "global");
    private static final Map<String, Statistics> ALL_STATISTICS = new LinkedHashMap<String, Statistics>();
    private final WorkspaceStorageConnection wcs;

    public StatisticsJDBCStorageConnection(WorkspaceStorageConnection wcs) {
        this.wcs = wcs;
    }

    public WorkspaceStorageConnection getNestedWorkspaceStorageConnection() {
        return this.wcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(ADD_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.add(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(ADD_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.add(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(CLOSE_DESCR);
        try {
            s.begin();
            this.wcs.close();
            Object var3_2 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(COMMIT_DESCR);
        try {
            s.begin();
            this.wcs.commit();
            Object var3_2 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(DELETE_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.delete(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(DELETE_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.delete(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_LAST_ORDER_NUMBER_DESCR);
        try {
            s.begin();
            int n = this.wcs.getLastOrderNumber(parent);
            Object var5_4 = null;
            s.end();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_COUNT_DESCR);
        try {
            s.begin();
            int n = this.wcs.getChildNodesCount(parent);
            Object var5_4 = null;
            s.end();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_NODES_DATA_DESCR);
        try {
            s.begin();
            List<NodeData> list = this.wcs.getChildNodesData(parent);
            Object var5_4 = null;
            s.end();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_CHILD_PROPERTIES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.getChildPropertiesData(parent);
            Object var5_4 = null;
            s.end();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException, IllegalStateException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR);
        try {
            s.begin();
            ItemData itemData = this.wcs.getItemData(parentData, name, itemType);
            Object var7_6 = null;
            s.end();
            return itemData;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(GET_ITEM_DATA_BY_ID_DESCR);
        try {
            s.begin();
            ItemData itemData = this.wcs.getItemData(identifier);
            Object var5_4 = null;
            s.end();
            return itemData;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        Statistics s = ALL_STATISTICS.get(GET_REFERENCES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.getReferencesData(nodeIdentifier);
            Object var5_4 = null;
            s.end();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        Statistics s = ALL_STATISTICS.get(IS_OPENED_DESCR);
        try {
            s.begin();
            boolean bl = this.wcs.isOpened();
            Object var4_3 = null;
            s.end();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(LIST_CHILD_PROPERTIES_DATA_DESCR);
        try {
            s.begin();
            List<PropertyData> list = this.wcs.listChildPropertiesData(parent);
            Object var5_4 = null;
            s.end();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(RENAME_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.rename(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IllegalStateException, RepositoryException {
        Statistics s = ALL_STATISTICS.get(ROLLBACK_DESCR);
        try {
            s.begin();
            this.wcs.rollback();
            Object var3_2 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(UPDATE_NODE_DATA_DESCR);
        try {
            s.begin();
            this.wcs.update(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        Statistics s = ALL_STATISTICS.get(UPDATE_PROPERTY_DATA_DESCR);
        try {
            s.begin();
            this.wcs.update(data);
            Object var4_3 = null;
            s.end();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.end();
            throw throwable;
        }
    }

    static {
        ALL_STATISTICS.put(GET_ITEM_DATA_BY_ID_DESCR, new Statistics(GLOBAL_STATISTICS, GET_ITEM_DATA_BY_ID_DESCR));
        ALL_STATISTICS.put(GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR, new Statistics(GLOBAL_STATISTICS, GET_ITEM_DATA_BY_NODE_DATA_NQ_PATH_ENTRY_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_DATA_DESCR));
        ALL_STATISTICS.put(GET_CHILD_NODES_COUNT_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_NODES_COUNT_DESCR));
        ALL_STATISTICS.put(GET_LAST_ORDER_NUMBER_DESCR, new Statistics(GLOBAL_STATISTICS, GET_LAST_ORDER_NUMBER_DESCR));
        ALL_STATISTICS.put(GET_CHILD_PROPERTIES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_CHILD_PROPERTIES_DATA_DESCR));
        ALL_STATISTICS.put(LIST_CHILD_PROPERTIES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, LIST_CHILD_PROPERTIES_DATA_DESCR));
        ALL_STATISTICS.put(GET_REFERENCES_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, GET_REFERENCES_DATA_DESCR));
        ALL_STATISTICS.put(COMMIT_DESCR, new Statistics(GLOBAL_STATISTICS, COMMIT_DESCR));
        ALL_STATISTICS.put(ADD_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, ADD_NODE_DATA_DESCR));
        ALL_STATISTICS.put(ADD_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, ADD_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(UPDATE_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, UPDATE_NODE_DATA_DESCR));
        ALL_STATISTICS.put(UPDATE_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, UPDATE_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(DELETE_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, DELETE_NODE_DATA_DESCR));
        ALL_STATISTICS.put(DELETE_PROPERTY_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, DELETE_PROPERTY_DATA_DESCR));
        ALL_STATISTICS.put(RENAME_NODE_DATA_DESCR, new Statistics(GLOBAL_STATISTICS, RENAME_NODE_DATA_DESCR));
        ALL_STATISTICS.put(ROLLBACK_DESCR, new Statistics(GLOBAL_STATISTICS, ROLLBACK_DESCR));
        ALL_STATISTICS.put(IS_OPENED_DESCR, new Statistics(null, IS_OPENED_DESCR));
        ALL_STATISTICS.put(CLOSE_DESCR, new Statistics(null, CLOSE_DESCR));
        if (JDBCWorkspaceDataContainer.STATISTICS_ENABLED) {
            JCRStatisticsManager.registerStatistics("JDBCStorageConnection", GLOBAL_STATISTICS, ALL_STATISTICS);
        }
    }
}

