/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableIOSupport;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.WriteValue;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;

public class CASableWriteValue
extends WriteValue {
    protected final ValueContentAddressStorage vcas;
    protected final CASableIOSupport cas;
    protected final String propertyId;
    protected final int orderNumb;
    protected File tempFile;
    protected File vcasFile;
    protected String vcasHash;

    public CASableWriteValue(ValueData value, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir, String propertyId, ValueContentAddressStorage vcas, CASableIOSupport cas) {
        super(null, value, resources, cleaner, tempDir);
        this.vcas = vcas;
        this.cas = cas;
        this.propertyId = propertyId;
        this.orderNumb = value.getOrderNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        this.makePerformed();
        File temp = new File(this.tempDir, IdGenerator.generate() + "-" + this.propertyId + this.orderNumb + ".temp");
        FileDigestOutputStream out = this.cas.openFile(temp);
        try {
            this.writeOutput(out, this.value);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            out.close();
            throw throwable;
        }
        out.close();
        this.vcasHash = out.getDigestHash();
        this.vcasFile = this.cas.getFile(this.vcasHash);
        this.fileLock = new ValueFileOperation.ValueFileLock(this.vcasFile);
        this.fileLock.lock();
        this.tempFile = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.fileLock != null) {
            try {
                try {
                    this.vcas.addValue(this.propertyId, this.orderNumb, this.vcasHash);
                }
                catch (RecordAlreadyExistsException e) {
                    if (this.tempFile != null && this.tempFile.exists() && !this.tempFile.delete()) {
                        LOG.warn((Object)("Can't delete CAS temp file. Added to file cleaner. " + this.tempFile.getAbsolutePath()));
                        this.cleaner.addFile(this.tempFile);
                    }
                    throw new RecordAlreadyExistsException("Write error: " + e, e);
                }
                if (!this.vcasFile.exists()) {
                    this.vcasFile.getParentFile().mkdirs();
                    if (!this.tempFile.renameTo(this.vcasFile)) {
                        throw new VCASException("File " + this.tempFile.getAbsolutePath() + " can't be renamed to VCAS-named " + this.vcasFile.getAbsolutePath());
                    }
                }
                if (!this.value.isByteArray() && this.value instanceof StreamPersistedValueData) {
                    ((StreamPersistedValueData)this.value).setPersistedFile(this.vcasFile);
                }
                Object var3_2 = null;
                this.tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.tempFile.delete();
                this.fileLock.unlock();
                throw throwable;
            }
            this.fileLock.unlock();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        if (this.fileLock != null) {
            try {
                this.tempFile.delete();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fileLock.unlock();
                throw throwable;
            }
            this.fileLock.unlock();
            {
            }
        }
    }
}

