/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.io.AbstractResource;
import org.jsecurity.io.ResourceException;

public abstract class TextResource
extends AbstractResource {
    private static final Log log = LogFactory.getLog(TextResource.class);
    protected String charsetName;

    public TextResource() {
    }

    public TextResource(String configBodyOrResourcePath) {
        this.load(configBodyOrResourcePath);
    }

    public TextResource(String configBodyOrResourcePath, String charsetName) {
        this.setCharsetName(charsetName);
        this.load(configBodyOrResourcePath);
    }

    public TextResource(InputStream is) {
        super(is);
    }

    public TextResource(Reader r) {
        this.load(r);
    }

    public TextResource(Scanner s) {
        this.load(s);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void load(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("'resourcePath' argument cannot be null.");
        }
        try {
            super.load(resourcePath);
        }
        catch (Exception e) {
            String msg = "Unable to load text resource from the resource path [" + resourcePath + "]";
            throw new ResourceException(msg, e);
        }
    }

    protected void doLoad(InputStream is) throws Exception {
        String charsetName = this.getCharsetName();
        InputStreamReader isr = charsetName != null ? new InputStreamReader(is, charsetName) : new InputStreamReader(is);
        this.load(isr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            this.doLoad(br);
        }
        finally {
            block8: {
                try {
                    br.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn((Object)("Unable to cleanly close BufferedReader [" + br + "] after " + "the doLoad(Reader) call."));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad(BufferedReader reader) {
        Scanner s = new Scanner(reader);
        try {
            this.load(s);
        }
        finally {
            s.close();
        }
    }

    public abstract void load(Scanner var1);
}

