/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content.multi;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/selector/content/multi/UIContentBrowsePanel.gtmpl", events={@EventConfig(listeners={UIContentBrowsePanel.ChangeContentTypeActionListener.class}), @EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={SaveTemporaryActionListener.class})})
public class UIContentBrowsePanelMulti
extends UIContentBrowsePanel {
    private String itemPaths;
    private String itemTarget;
    private String deleteConfirmationMsg = "UIBrowserPanel.Confirm.Delete";
    private String _initPath = "";
    private String _initDrive = "";

    public String getItemPaths() {
        return this.itemPaths;
    }

    public void setInitPath(String initDrive, String initPath) {
        this._initPath = initPath;
        this._initDrive = initDrive;
    }

    public String getInitDrive() {
        return this._initDrive;
    }

    public String getInitPath() {
        return this._initPath;
    }

    public void setItemPaths(String itemPaths) {
        this.itemPaths = itemPaths;
        this.setItemTargetPath(this.getTargetPath(itemPaths));
    }

    public void setItemTargetPath(String _itemTarget) {
        this.itemTarget = _itemTarget;
    }

    public String getItemTargetPath() {
        return this.itemTarget;
    }

    protected String getTargetPath(String savedItems) {
        String[] savedItemList = savedItems.split(";");
        int n = savedItemList.length;
        StringBuilder result = new StringBuilder("");
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        for (int i = 0; i < n; ++i) {
            String savedItem = savedItemList[i];
            String[] locations = savedItem == null ? null : savedItem.split(":");
            Node node = locations != null && locations.length >= 3 ? Utils.getViewableNodeByComposer(locations[0], locations[1], locations[2]) : null;
            savedItem = "";
            if (node != null) {
                try {
                    savedItem = node.getPath();
                    if (linkManager.isLink(node)) {
                        node = linkManager.getTarget(node);
                        savedItem = node.getPath();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            result.append(savedItem).append(";");
        }
        return result.toString();
    }

    public String getDeleteConfirmationMsg() {
        return org.exoplatform.ecm.webui.utils.Utils.getResourceBundle("locale.portlet.i18n.WebUIDms", this.deleteConfirmationMsg, UIContentBrowsePanelMulti.class.getClassLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIContentBrowsePanelMulti> {
        public void execute(Event<UIContentBrowsePanelMulti> event) throws Exception {
            UIContentBrowsePanelMulti contentBrowsePanelMulti = (UIContentBrowsePanelMulti)event.getSource();
            ((UISelectable)contentBrowsePanelMulti.getSourceComponent()).doSelect(null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveTemporaryActionListener
    extends EventListener<UIContentBrowsePanelMulti> {
        public void execute(Event<UIContentBrowsePanelMulti> event) throws Exception {
            String[] locations;
            UIContentBrowsePanelMulti contentBrowsePanelMulti = (UIContentBrowsePanelMulti)event.getSource();
            Node node = null;
            String itemPaths = event.getRequestContext().getRequestParameter("objectId");
            String iDriver = event.getRequestContext().getRequestParameter("driverName");
            String iPath = event.getRequestContext().getRequestParameter("currentPath");
            String[] stringArray = locations = iPath == null ? null : iPath.split(":");
            if (iDriver != null && iDriver.length() > 0) {
                if (locations != null && locations.length > 2) {
                    node = Utils.getViewableNodeByComposer(locations[0], locations[1], locations[2], "base");
                }
                if (node != null) {
                    String repoName = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
                    iPath = this.fixPath(iDriver, node.getPath(), repoName, contentBrowsePanelMulti);
                    contentBrowsePanelMulti.setInitPath(iDriver, iPath);
                } else {
                    contentBrowsePanelMulti.setInitPath(iDriver, iPath);
                }
            } else {
                contentBrowsePanelMulti.setInitPath("", "");
            }
            contentBrowsePanelMulti.setItemPaths(itemPaths);
            UIContentSelector contentSelector = (UIContentSelector)contentBrowsePanelMulti.getAncestorOfType(UIContentSelector.class);
            contentSelector.setSelectedTab(contentBrowsePanelMulti.getId());
        }

        private String fixPath(String driveName, String path, String repository, UIContentBrowsePanelMulti uiBrowser) throws Exception {
            if (path == null || path.length() == 0 || repository == null || repository.length() == 0) {
                return "";
            }
            ManageDriveService managerDriveService = (ManageDriveService)uiBrowser.getApplicationComponent(ManageDriveService.class);
            DriveData driveData = managerDriveService.getDriveByName(driveName, repository);
            if (!path.startsWith(driveData.getHomePath())) {
                return "";
            }
            if ("/".equals(driveData.getHomePath())) {
                return path;
            }
            return path.substring(driveData.getHomePath().length());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIContentBrowsePanelMulti> {
        public void execute(Event<UIContentBrowsePanelMulti> event) throws Exception {
            UIContentBrowsePanelMulti contentBrowsePanelMulti = (UIContentBrowsePanelMulti)event.getSource();
            String returnFieldName = contentBrowsePanelMulti.getReturnFieldName();
            String itemPaths = event.getRequestContext().getRequestParameter("objectId");
            ((UISelectable)contentBrowsePanelMulti.getSourceComponent()).doSelect(returnFieldName, itemPaths);
        }
    }
}

