/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.Event;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsWrapper {
    protected static Log log = ExoLogger.getLogger((String)"portal:EventsWrapper");
    private List<Event> events;
    private List<CounterWrapper> counters = new ArrayList<CounterWrapper>();
    public static final int THRESHOLD = 4;

    public EventsWrapper(List<Event> events) {
        this.events = events;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<CounterWrapper> getCounters() {
        return this.counters;
    }

    public void increaseCounter(UIPortlet portlet) {
        for (CounterWrapper counter : this.counters) {
            if (!portlet.getWindowId().equals(counter.portletId)) continue;
            ++counter.counter;
            return;
        }
        this.counters.add(new CounterWrapper(portlet.getStorageId()));
    }

    public boolean isInvokedTooManyTimes(UIPortlet portlet) {
        for (CounterWrapper counter : this.counters) {
            if (!portlet.getWindowId().equals(counter.portletId)) continue;
            if (counter.counter + 1 > 4) {
                log.info((Object)("Portlet " + portlet.getWindowId() + " has already been invokated " + 4 + " times and will not be more to avoid infinite cycles"));
                return true;
            }
            return false;
        }
        return false;
    }

    public class CounterWrapper {
        public String portletId;
        public int counter = 0;

        public CounterWrapper(String portletId) {
            this.portletId = portletId;
        }
    }
}

