/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/application/UIApplicationList.gtmpl", events={@EventConfig(listeners={SelectCategoryActionListener.class})})
public class UIApplicationList
extends UIContainer {
    private List<ApplicationCategory> categories;
    private ApplicationCategory selectedCategory;

    public UIApplicationList() throws Exception {
        ApplicationRegistryService service = (ApplicationRegistryService)this.getApplicationComponent(ApplicationRegistryService.class);
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        if (remoteUser == null || remoteUser.equals("")) {
            return;
        }
        UserACL userACL = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        PortletComparator portletComparator = new PortletComparator();
        this.categories = service.getApplicationCategories(remoteUser, new ApplicationType[0]);
        Iterator<ApplicationCategory> cateItr = this.categories.iterator();
        while (cateItr.hasNext()) {
            String permssion;
            ApplicationCategory cate = cateItr.next();
            List applications = cate.getApplications();
            boolean hasPermission = false;
            ArrayList accessPermission = cate.getAccessPermissions();
            if (accessPermission == null) {
                accessPermission = new ArrayList();
            }
            if (accessPermission.size() == 0) {
                accessPermission.add(null);
            }
            Iterator i$ = accessPermission.iterator();
            while (i$.hasNext() && !(hasPermission = userACL.hasPermission(permssion = (String)i$.next()))) {
            }
            if (!hasPermission || applications.size() < 1) {
                cateItr.remove();
                continue;
            }
            Collections.sort(applications, portletComparator);
        }
        if (this.categories.size() > 0) {
            this.setSelectedCategory(this.categories.get(0).getName());
        }
        Collections.sort(this.categories, new PortletCategoryComparator());
    }

    public Application getApplication(String id) throws Exception {
        for (ApplicationCategory category : this.categories) {
            List items = category.getApplications();
            for (Application item : items) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    public ApplicationCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(String categoryName) {
        for (ApplicationCategory category : this.categories) {
            if (!category.getName().equals(categoryName)) continue;
            this.selectedCategory = category;
        }
    }

    public List<Application> getApplications() {
        if (this.selectedCategory == null) {
            return null;
        }
        List apps = this.selectedCategory.getApplications();
        GadgetRegistryService gadgetService = (GadgetRegistryService)this.getApplicationComponent(GadgetRegistryService.class);
        for (Application app : apps) {
            if (!ApplicationType.GADGET.equals(app.getType())) continue;
            try {
                Gadget gadget = gadgetService.getGadget(app.getApplicationName());
                if (gadget == null) continue;
                app.setIconURL(gadget.getThumbnail());
            }
            catch (Exception e) {}
        }
        return apps;
    }

    public List<ApplicationCategory> getCategories() {
        return this.categories;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectCategoryActionListener
    extends EventListener<UIApplicationList> {
        public void execute(Event<UIApplicationList> event) throws Exception {
            String category = event.getRequestContext().getRequestParameter("objectId");
            UIApplicationList uiApplicationList = (UIApplicationList)((Object)event.getSource());
            uiApplicationList.setSelectedCategory(category);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplicationList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletComparator
    implements Comparator<Application> {
        PortletComparator() {
        }

        @Override
        public int compare(Application p1, Application p2) {
            return p1.getDisplayName().compareToIgnoreCase(p2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletCategoryComparator
    implements Comparator<ApplicationCategory> {
        PortletCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getDisplayName().compareToIgnoreCase(cat2.getDisplayName());
        }
    }
}

